/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.engine.ToolManager;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ErrorPane;
import com.xiaomitool.v2.gui.visual.LoadingAnimation;
import com.xiaomitool.v2.gui.visual.TextStackPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.GuiListenerAbstract;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.utility.CommandClass;
import com.xiaomitool.v2.utility.CommandClass$Command;
import com.xiaomitool.v2.utility.utils.StrUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class InstallPane
extends StackPane
implements GuiListenerAbstract {
    private TextStackPane textStackPane;
    private final CommandClass commandManager = new CommandClass();

    public InstallPane() {
        this.build();
    }

    private void build() {
        double d2 = WindowManager.getContentWidth();
        double d3 = WindowManager.getContentHeight();
        LoadingAnimation loadingAnimation = new LoadingAnimation(d2 / 6.0);
        double d4 = loadingAnimation.getCircleRadius() + 30.0;
        this.textStackPane = new TextStackPane(d2, d3 - d4);
        VBox vBox = new VBox(new Node[]{this.textStackPane, loadingAnimation});
        vBox.setSpacing(20.0);
        vBox.setAlignment(Pos.CENTER);
        super.getChildren().add((Object)vBox);
    }

    @Override
    public void text(String string) {
        if (this.textStackPane == null) {
            this.toast(string);
            return;
        }
        this.textStackPane.addText(string);
    }

    @Override
    public void toast(String string) {
        WindowManager.toast(string);
    }

    @Override
    public void onException(InstallException installException) {
        int n;
        ToolManager.setOnExitAskForFeedback(false);
        Log.log("FATAL", installException.toString(), true);
        Log.exc(installException);
        Log.exc(new Exception("TraceBackException"));
        Log.printStackTrace(installException);
        String string = StrUtils.exceptionToOriginString(installException);
        ErrorPane errorPane = new ErrorPane(LRes.CANCEL, LRes.STEP_BACK, LRes.TRY_AGAIN);
        errorPane.setTitle(LRes.PROCEDURE_EXC_TITLE.toString(), (Paint)Color.rgb((int)128, (int)0, (int)0));
        Text text = WindowManager.newText(LRes.PROCEDURE_EXC_TEXT.toString(), true);
        Text text2 = WindowManager.newText(installException.getMessage(), true);
        StackPane stackPane = new StackPane(new Node[]{text2});
        stackPane.setPadding(new Insets(5.0));
        Text text3 = WindowManager.newText(LRes.PROCEDURE_EXC_TEXT_2.toString(new Object[]{installException.getCode().toString(), string, LRes.TRY_AGAIN, LRes.STEP_BACK, LRes.CANCEL}), true);
        text2.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)17.0));
        errorPane.appendContent((Node)text);
        errorPane.appendContent((Node)stackPane);
        errorPane.appendContent((Node)text3);
        WindowManager.setMainContent((Node)errorPane, false);
        try {
            n = errorPane.waitClick();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        WindowManager.removeTopContent();
        if (n == 0) {
            this.sendCommand(CommandClass$Command.ABORT);
        } else if (n == 1) {
            this.sendCommand(CommandClass$Command.UPLEVEL);
        } else {
            this.sendCommand(CommandClass$Command.RETRY);
        }
    }

    @Override
    public CommandClass$Command exception(InstallException installException, Runnable runnable) {
        this.onException(installException);
        if (runnable != null) {
            runnable.run();
        }
        return this.waitCommand();
    }

    @Override
    public void sendCommand(CommandClass$Command commandClass$Command) {
        this.commandManager.sendCommand(commandClass$Command);
    }

    @Override
    public CommandClass$Command waitCommand() {
        return this.commandManager.waitCommand();
    }

    @Override
    public boolean isWaitingCommand() {
        return this.commandManager.isWaitingCommand();
    }
}

