/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class TextStackPane
extends StackPane {
    private Color background = WindowManager.DEFAULT_BACKGROUND_COLOR;
    private double paneWidth;
    private double paneHeight;
    private double moved = 0.0;
    private VBox vBox;
    private HBox hBox;
    private Pane movingPane;

    public TextStackPane(double d2, double d3) {
        this.paneWidth = d2;
        this.paneHeight = d3;
        this.build();
    }

    private void build() {
        this.vBox = new VBox();
        this.vBox.setAlignment(Pos.TOP_CENTER);
        this.vBox.setPrefHeight(-1.0);
        this.hBox = new HBox(new Node[]{this.vBox});
        this.hBox.setPrefWidth(this.paneWidth);
        this.hBox.setAlignment(Pos.TOP_CENTER);
        this.hBox.setLayoutY(this.paneHeight);
        this.movingPane = new Pane(new Node[]{this.hBox});
        ImageView imageView = new ImageView(new Image(DrawableManager.getPng("overlay").toString(), this.paneWidth, this.paneHeight, false, true));
        imageView.setFitHeight(this.paneHeight);
        imageView.setFitWidth(this.paneWidth);
        super.getChildren().addAll((Object[])new Node[]{this.movingPane, imageView});
        super.setPrefSize(this.paneWidth, this.paneHeight);
        super.setMaxSize(this.paneWidth, this.paneHeight);
        this.movingPane.setClip((Node)new Rectangle(this.paneWidth, this.paneHeight));
        super.setClip((Node)new Rectangle(this.paneWidth, this.paneHeight));
        super.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.background, null, null)}));
    }

    public void addText(String string) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.addText(string));
            return;
        }
        Text text = new Text(string);
        text.setTextAlignment(TextAlignment.CENTER);
        if (super.getWidth() > 0.0) {
            text.setWrappingWidth(super.getWidth() * 0.9);
        } else {
            text.setWrappingWidth(this.paneWidth);
        }
        text.setFont(Font.font((double)16.0));
        StackPane stackPane = new StackPane(new Node[]{text});
        double d2 = text.getLayoutBounds().getHeight();
        stackPane.setMaxHeight(d2 += 14.0);
        stackPane.setMinHeight(d2);
        stackPane.setPrefHeight(d2);
        this.vBox.getChildren().add((Object)stackPane);
        d2 += this.moved + 1.0;
        if (d2 > 0.0) {
            this.buildTransition((Node)this.hBox, d2).play();
        }
        this.moved = d2;
    }

    private Transition buildTransition(Node node, double d2) {
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)500.0), node);
        translateTransition.setFromY(node.getTranslateY());
        translateTransition.setToY(-1.0 * d2);
        translateTransition.setCycleCount(1);
        translateTransition.setAutoReverse(false);
        translateTransition.setInterpolator(Interpolator.EASE_OUT);
        return translateTransition;
    }
}

