/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.language;

import com.xiaomitool.v2.inet.EasyHttp;
import com.xiaomitool.v2.inet.EasyResponse;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.language.Lang$RegionLanguage;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.Pair;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Lang {
    private static final String STRING_ELEMNENT_NAME = "string";
    private static final String STRING_ID = "id";
    private static HashMap<String, LinkedHashMap<String, Lang$RegionLanguage>> loadedLanguages = new HashMap();
    private static HashMap<String, String> dictionary = new HashMap();
    private static String langHost = null;

    public static void initOnlineLangs(String string2) {
        langHost = string2 + "/lang";
        String string3 = langHost + "/index.json";
        JSONArray jSONArray = new JSONArray(EasyHttp.get(string3).getBody());
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            Lang$RegionLanguage lang$RegionLanguage = Lang$RegionLanguage.fromJsonEntry(jSONObject);
            LinkedHashMap linkedHashMap = loadedLanguages.computeIfAbsent(lang$RegionLanguage.getLangCode(), string -> new LinkedHashMap());
            linkedHashMap.put(lang$RegionLanguage.getRegionCode(), lang$RegionLanguage);
        }
        Path path = ResourcesManager.getLangPath();
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public static List<Pair<String, String>> getComboChoices() {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        for (LinkedHashMap<String, Lang$RegionLanguage> linkedHashMap : loadedLanguages.values()) {
            boolean bl = linkedHashMap.size() > 1;
            for (Lang$RegionLanguage lang$RegionLanguage : linkedHashMap.values()) {
                String string = lang$RegionLanguage.getLangName();
                if (bl) {
                    string = string + " (" + lang$RegionLanguage.getRegionName() + ")";
                }
                arrayList.add(new Pair<String, String>(lang$RegionLanguage.toLocaleCode(), string));
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new Pair<String, String>("en_US", "English"));
        }
        return arrayList;
    }

    public static String text(String string, Object ... objectArray) {
        String string2 = Lang.getFormat(string);
        return String.format(string2, objectArray);
    }

    private static String getFormat(String string) {
        String string2 = dictionary.get(string);
        if (string2 == null) {
            throw new Exception("Missing text id:" + string);
        }
        return string2;
    }

    public static void saveToXmlFile(Path path) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("strings");
        document.appendChild(element);
        for (LRes lRes : LRes.values()) {
            Element element2 = document.createElement(STRING_ELEMNENT_NAME);
            element2.setAttribute(STRING_ID, lRes.getKey());
            element2.setTextContent(lRes.toEnglish().replace("\n", "\\n"));
            element.appendChild(element2);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(path.toFile());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "html");
        transformer.transform(dOMSource, streamResult);
    }

    private static void loadFromInputStream(InputStream inputStream) {
        dictionary = new HashMap();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        NodeList nodeList = document.getElementsByTagName(STRING_ELEMNENT_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String string = element.getAttribute(STRING_ID);
            String string2 = element.getTextContent();
            if (string == null || string2 == null) continue;
            string2 = string2.replaceAll("\\\\n", "\n");
            dictionary.put(string, string2);
        }
    }

    private static void loadFromXmlFile(Path path) {
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
            Lang.loadFromInputStream(fileInputStream);
        }
        Log.info("Loading language from file: " + path.toString());
    }

    public static void load() {
        String string = SettingsUtils.getLanguage();
        if (Lang.tryLoadLangCode(string)) {
            return;
        }
        Lang$RegionLanguage lang$RegionLanguage = Lang.getSystemRegionLanguage();
        if (Lang.tryLoadRegionLanguage(lang$RegionLanguage)) {
            return;
        }
        if (Lang.tryLoadLangCode("en_US")) {
            return;
        }
        Log.warn("Failed to load system or choice lang, switch to english");
        dictionary = null;
    }

    private static void loadLangCode(String string) {
        String[] stringArray = string.split("_", 2);
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : null;
        Lang$RegionLanguage lang$RegionLanguage = Lang.getBestFittingRegionLanguage(string2, string3);
        String string4 = null;
        if (lang$RegionLanguage != null) {
            string2 = lang$RegionLanguage.getLangCode();
            string3 = lang$RegionLanguage.getRegionCode();
            string = lang$RegionLanguage.toLocaleCode();
            string4 = lang$RegionLanguage.getHash();
        }
        Path path = ResourcesManager.getLangFilePath(string);
        boolean bl = Files.exists(path, new LinkOption[0]);
        if (string4 != null) {
            boolean bl2 = true;
            if (bl) {
                String string5 = "";
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(path.toFile()));){
                    string5 = DigestUtils.md5Hex(bufferedInputStream);
                }
                boolean bl3 = bl2 = !string4.equalsIgnoreCase(string5);
            }
            if (bl2) {
                Lang.downloadLangFile(string, path);
                bl = true;
            }
        }
        if (!bl) {
            throw new Exception("Lang file not present and not downloadable");
        }
        Lang.loadFromXmlFile(path);
    }

    private static void downloadLangFile(String string, Path path) {
        Log.info("Downloading lang file: " + string);
        EasyResponse easyResponse = EasyHttp.get(langHost + "/" + string + ".xml");
        if (!easyResponse.isAllRight()) {
            throw new Exception("Failed to download the lang file: " + easyResponse.getCode());
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());){
            ((OutputStream)fileOutputStream).write(easyResponse.getBody().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static boolean tryLoadLangCode(String string) {
        if (string == null) {
            return false;
        }
        try {
            Lang.loadLangCode(string);
            return true;
        }
        catch (Exception exception) {
            Log.warn("Failed to load language: " + string + ": " + exception.getMessage());
            return false;
        }
    }

    private static boolean tryLoadRegionLanguage(Lang$RegionLanguage lang$RegionLanguage) {
        if (lang$RegionLanguage == null) {
            return false;
        }
        return Lang.tryLoadLangCode(lang$RegionLanguage.toLocaleCode());
    }

    public static Lang$RegionLanguage getSystemRegionLanguage() {
        Locale locale = Lang.getSystemLocale();
        if (locale == null) {
            return null;
        }
        return Lang.getBestFittingRegionLanguage(locale.getLanguage(), locale.getCountry());
    }

    private static Lang$RegionLanguage getBestFittingRegionLanguage(String string, String string2) {
        Lang$RegionLanguage lang$RegionLanguage;
        LinkedHashMap<String, Lang$RegionLanguage> linkedHashMap;
        LinkedHashMap<String, Lang$RegionLanguage> linkedHashMap2 = linkedHashMap = string == null ? null : loadedLanguages.get(string.toLowerCase());
        if (linkedHashMap == null) {
            return null;
        }
        Lang$RegionLanguage lang$RegionLanguage2 = lang$RegionLanguage = string2 == null ? null : linkedHashMap.get(string2.toUpperCase());
        if (lang$RegionLanguage == null) {
            lang$RegionLanguage = linkedHashMap.values().iterator().next();
        }
        return lang$RegionLanguage;
    }

    private static Locale getSystemLocale() {
        return Locale.getDefault();
    }
}

