/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.logging.feedback;

import com.xiaomitool.v2.logging.feedback.LiveFeedback$Feedback;
import com.xiaomitool.v2.logging.feedback.LiveFeedback$Feedback$Builder;
import com.xiaomitool.v2.logging.feedback.LiveFeedback$FeedbackType;
import com.xiaomitool.v2.logging.feedback.LiveFeedbackEasy$1;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.utility.WaitSemaphore;
import com.xiaomitool.v2.utility.utils.CompressUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LiveFeedbackEasy {
    private static final ConcurrentLinkedQueue<LiveFeedback$Feedback> QUEUED_FEEDBACKS = new ConcurrentLinkedQueue();
    private static boolean isOpen = false;
    private static Instant lastFeedbackInstant = null;
    private static WaitSemaphore feedbackSent = new WaitSemaphore(1);

    private LiveFeedbackEasy() {
    }

    public static void sendError(String string, String string2) {
        LiveFeedbackEasy.send(string, string2, LiveFeedback$FeedbackType.ERROR);
    }

    public static void sendSuccess(String string, String string2) {
        LiveFeedbackEasy.send(string, string2, LiveFeedback$FeedbackType.SUCCESS);
    }

    public static void sendOpen(String string, String string2) {
        isOpen = true;
        LiveFeedbackEasy.send(string, string2, LiveFeedback$FeedbackType.OPEN);
    }

    public static void sendClose() {
        LiveFeedbackEasy.sendClose(null, null);
    }

    public static void sendClose(String string, String string2) {
        LiveFeedbackEasy.send(string, string2, LiveFeedback$FeedbackType.CLOSE);
        isOpen = false;
    }

    public static void sendLog(String string, String string2) {
        LiveFeedbackEasy.send(string, string2, LiveFeedback$FeedbackType.LOG);
    }

    public static void sendInstallException(InstallException installException, ProcedureRunner procedureRunner) {
        LiveFeedbackEasy.sendError(installException.getCode().toString(), installException.getMessage() + StrUtils.exceptionToString(installException) + "\n\n" + procedureRunner.getStackStrace());
    }

    public static void waitFeedbackSent() {
        feedbackSent.waitOnce();
    }

    public static void runOnFeedbackSent(Runnable runnable, boolean bl) {
        LiveFeedbackEasy$1 liveFeedbackEasy$1 = new LiveFeedbackEasy$1(runnable);
        if (bl) {
            new Thread(liveFeedbackEasy$1).start();
        } else {
            liveFeedbackEasy$1.run();
        }
    }

    private static synchronized void send(String string, String string2, LiveFeedback$FeedbackType liveFeedback$FeedbackType) {
        feedbackSent.setPermits(0);
        feedbackSent.increase();
    }

    private static LiveFeedback$Feedback newMessage(String string, String string2, LiveFeedback$FeedbackType liveFeedback$FeedbackType) {
        LiveFeedback$Feedback$Builder liveFeedback$Feedback$Builder = LiveFeedback$Feedback.newBuilder().setTime(System.currentTimeMillis());
        if (string != null) {
            liveFeedback$Feedback$Builder.setQuickMessage(string);
        }
        if (string2 != null) {
            liveFeedback$Feedback$Builder.setLongMessage(string2);
        }
        liveFeedback$Feedback$Builder.setType(liveFeedback$FeedbackType);
        return liveFeedback$Feedback$Builder.build();
    }

    private static byte[] getSendableMessage(byte[] byArray) {
        byte[] byArray2 = CompressUtils.paddedCompress(byArray, 4);
        int n = byArray2.length - 4;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2, 0, 4);
        byteBuffer.putInt(n);
        return byArray2;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$000() {
        return QUEUED_FEEDBACKS;
    }

    static /* synthetic */ LiveFeedback$Feedback access$100(String string, String string2, LiveFeedback$FeedbackType liveFeedback$FeedbackType) {
        return LiveFeedbackEasy.newMessage(string, string2, liveFeedback$FeedbackType);
    }

    static /* synthetic */ Instant access$200() {
        return lastFeedbackInstant;
    }

    static /* synthetic */ byte[] access$300(byte[] byArray) {
        return LiveFeedbackEasy.getSendableMessage(byArray);
    }

    static /* synthetic */ WaitSemaphore access$400() {
        return feedbackSent;
    }
}

