/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure;

import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.PopupWindow$Icon;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ButtonPane;
import com.xiaomitool.v2.gui.visual.DragAndDropPane;
import com.xiaomitool.v2.gui.visual.SidePane;
import com.xiaomitool.v2.gui.visual.SortableTableView;
import com.xiaomitool.v2.gui.visual.SortableTableView$TableViewColumn;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures$1;
import com.xiaomitool.v2.procedure.Procedures$2;
import com.xiaomitool.v2.procedure.Procedures$3;
import com.xiaomitool.v2.procedure.Procedures$4;
import com.xiaomitool.v2.procedure.Procedures$5;
import com.xiaomitool.v2.procedure.Procedures$6;
import com.xiaomitool.v2.procedure.Procedures$7;
import com.xiaomitool.v2.procedure.Procedures$8;
import com.xiaomitool.v2.procedure.Procedures$FileEntry;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.rom.chooser.InstallableChooser;
import com.xiaomitool.v2.rom.chooser.ProcedureChooser;
import com.xiaomitool.v2.rom.interfaces.StatedProcedure;
import com.xiaomitool.v2.utility.CommandClass$Command;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;

public class Procedures {
    public static final String SELECTED_DEVICE = "selected_device";
    public static final String INSTALLABLE = "installable";
    public static final String REQUEST_PARAMS = "request_params";
    private static final String TO_DO_STACK = "to_do_stack";
    private static final String INSTALLABLE_CHOOSER = "installable_chooser";
    private static final String PROCEDURE_CHOOSER = "procedure_chooser";
    private static final String SAVED_PROCE = "saved_proce";

    public static String getDeviceProperty(ProcedureRunner procedureRunner, String string) {
        Object object = procedureRunner.getContext("prop_" + string);
        if (object != null) {
            return object.toString();
        }
        Device device = (Device)procedureRunner.requireContext(SELECTED_DEVICE);
        object = device.getDeviceProperties().get(string);
        return object == null ? null : object.toString();
    }

    public static String requireDeviceProperty(ProcedureRunner procedureRunner, String string) {
        String string2 = Procedures.getDeviceProperty(procedureRunner, string);
        if (string2 == null) {
            throw new InstallException("Failed to get device property: " + string, InstallException$Code.INFO_RETRIVE_FAILED);
        }
        return string2;
    }

    public static List<File> selectFilesFromPc(String string, String string2, FileChooser.ExtensionFilter ... extensionFilterArray) {
        int n;
        SidePane sidePane = new SidePane();
        SortableTableView sortableTableView = new SortableTableView(new SortableTableView$TableViewColumn<Procedures$FileEntry>(LRes.SELECTED_FILE_LIST.toString(), Procedures$FileEntry::pathProperty, 300.0));
        sortableTableView.setPrefSize(300.0, 250.0);
        sidePane.setLeft((Node)GuiUtils.center(sortableTableView));
        DragAndDropPane dragAndDropPane = new DragAndDropPane(300.0, 300.0);
        dragAndDropPane.setFilters(extensionFilterArray);
        sidePane.setRight((Node)GuiUtils.center((Node)dragAndDropPane));
        Text text = new Text(string);
        text.setFont(Font.font((double)20.0));
        dragAndDropPane.setOnFileChange(new Procedures$1(sortableTableView, dragAndDropPane));
        text.setTextAlignment(TextAlignment.CENTER);
        text.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        Text text2 = new Text(string2);
        text2.setFont(Font.font((double)16.0));
        text2.setTextAlignment(TextAlignment.CENTER);
        text2.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        VBox vBox = new VBox(new Node[]{text, text2, sidePane});
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(10.0);
        ButtonPane buttonPane = new ButtonPane(LRes.CONTINUE, LRes.CANCEL);
        buttonPane.setContent((Node)vBox);
        WindowManager.setMainContent((Node)buttonPane, false);
        LinkedList<File> linkedList = null;
        while ((n = buttonPane.waitClick()) != 1) {
            ObservableList observableList = sortableTableView.getItems();
            if (observableList.isEmpty()) {
                WindowManager.popup(LRes.FILE_PLEASE_SELECT_POPUP.toString(), PopupWindow$Icon.WARN);
                continue;
            }
            linkedList = new LinkedList<File>();
            for (Procedures$FileEntry procedures$FileEntry : observableList) {
                linkedList.add(Procedures$FileEntry.access$000(procedures$FileEntry));
            }
        }
        WindowManager.removeTopContent();
        return linkedList;
    }

    public static File selectFileFromPc(String string, String string2, FileChooser.ExtensionFilter ... extensionFilterArray) {
        Text text = new Text(string);
        text.setFont(Font.font((double)20.0));
        text.setTextAlignment(TextAlignment.CENTER);
        text.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        Text text2 = new Text(string2);
        text2.setFont(Font.font((double)16.0));
        text2.setTextAlignment(TextAlignment.CENTER);
        text2.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        DragAndDropPane dragAndDropPane = new DragAndDropPane(300.0, 300.0);
        dragAndDropPane.setFilters(extensionFilterArray);
        VBox vBox = new VBox(new Node[]{text, text2, GuiUtils.center((Node)dragAndDropPane)});
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(10.0);
        ButtonPane buttonPane = new ButtonPane(LRes.CONTINUE, LRes.CANCEL);
        buttonPane.setContent((Node)vBox);
        WindowManager.setMainContent((Node)buttonPane, false);
        File file = null;
        while (file == null) {
            if (buttonPane.waitClick() == 1) {
                return null;
            }
            file = dragAndDropPane.getSelectedFile();
            if (file != null) continue;
            WindowManager.popup(LRes.FILE_PLEASE_SELECT_POPUP.toString(), PopupWindow$Icon.WARN);
        }
        WindowManager.removeTopContent();
        return file;
    }

    public static Device requireDevice(ProcedureRunner procedureRunner) {
        return (Device)procedureRunner.requireContext(SELECTED_DEVICE);
    }

    public static Installable requireInstallable(ProcedureRunner procedureRunner) {
        return (Installable)procedureRunner.requireContext(INSTALLABLE);
    }

    public static InstallableChooser requireInstallableChooser(ProcedureRunner procedureRunner) {
        InstallableChooser installableChooser = (InstallableChooser)procedureRunner.getContext(INSTALLABLE_CHOOSER);
        if (installableChooser != null) {
            return installableChooser;
        }
        installableChooser = new InstallableChooser();
        procedureRunner.setContext(INSTALLABLE_CHOOSER, installableChooser);
        return installableChooser;
    }

    public static void setInstallable(ProcedureRunner procedureRunner, Installable installable) {
        procedureRunner.setContext(INSTALLABLE, installable);
    }

    public static void pushRInstallOnStack(ProcedureRunner procedureRunner, RInstall rInstall) {
        LinkedList<RInstall> linkedList = (LinkedList<RInstall>)procedureRunner.getContext(TO_DO_STACK);
        if (linkedList == null) {
            linkedList = new LinkedList<RInstall>();
            procedureRunner.setContext(TO_DO_STACK, linkedList);
        }
        if (linkedList.size() > 0) {
            Log.warn("Multiple procedures on the stack: " + linkedList);
        }
        linkedList.addLast(rInstall);
    }

    public static RInstall throwRMessage(CommandClass$Command commandClass$Command) {
        return new Procedures$2(commandClass$Command);
    }

    public static RInstall throwInstallException(InstallException installException) {
        return new Procedures$3(installException);
    }

    public static RInstall runSavedProcedure(String string) {
        return new Procedures$4(string);
    }

    public static RInstall saveProcedure(String string, RInstall rInstall) {
        return new Procedures$5(string, rInstall);
    }

    public static RInstall runStackedProcedures() {
        return new Procedures$6();
    }

    public static File getInstallableFile(Installable installable) {
        File file = installable.getFinalFile();
        if (file != null) {
            return file;
        }
        file = installable.getDownloadedFile();
        if (file != null) {
            return file;
        }
        throw new InstallException("Installable doesn't contain file", InstallException$Code.FILE_NOT_FOUND, "Null downloaded file and final file, url: " + installable.getDownloadUrl());
    }

    public static ProcedureChooser requireProcedureChooser(ProcedureRunner procedureRunner) {
        ProcedureChooser procedureChooser = (ProcedureChooser)procedureRunner.getContext(PROCEDURE_CHOOSER);
        if (procedureChooser == null) {
            procedureChooser = new ProcedureChooser();
            procedureRunner.setContext(PROCEDURE_CHOOSER, procedureChooser);
        }
        return procedureChooser;
    }

    public static RInstall doNothing() {
        return new Procedures$7();
    }

    public static boolean stillNeedUsbDebug(ProcedureRunner procedureRunner, StatedProcedure statedProcedure) {
        return Procedures.getAllRequiredStates(procedureRunner, statedProcedure).contains((Object)Device$Status.DEVICE);
    }

    private static LinkedHashSet<Device$Status> getAllRequiredStates(ProcedureRunner procedureRunner, StatedProcedure statedProcedure) {
        Device device = Procedures.requireDevice(procedureRunner);
        Device$Status device$Status = device.getStatus();
        if (!device.isConnected()) {
            device$Status = null;
        }
        LinkedHashSet<Device$Status> linkedHashSet = new LinkedHashSet<Device$Status>();
        for (Device$Status device$Status2 : statedProcedure.getRequiredStates()) {
            linkedHashSet.add(device$Status2);
            if (!device$Status2.equals((Object)device$Status) && (device$Status == null || Device$Status.FASTBOOT.equals((Object)device$Status))) {
                linkedHashSet.add(Device$Status.DEVICE);
            }
            device$Status = device$Status2;
        }
        return linkedHashSet;
    }

    public static RInstall featureNotAvailable() {
        return new Procedures$8();
    }
}

