/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.fetch;

import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;

final class GenericFetch$1
extends RInstall {
    GenericFetch$1() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        File file = (File)procedureRunner.requireContext("gen_sel_file");
        Log.info("Computing MD5 hash of file: " + file);
        if (!file.exists()) {
            throw new InstallException("File not found: " + file.toString(), InstallException$Code.FILE_NOT_FOUND);
        }
        String string = "";
        procedureRunner.text(LRes.CALCULATING_MD5);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            string = DigestUtils.md5Hex(bufferedInputStream);
        }
        catch (IOException iOException) {
            throw new InstallException("Failed to calculate file md5: " + file, InstallException$Code.HASH_FAILED, iOException);
        }
        if (StrUtils.isNullOrEmpty(string)) {
            throw new InstallException("Failed to calculate file md5: " + file.toString(), InstallException$Code.HASH_FAILED, "Null or empty result hash");
        }
        procedureRunner.setContext("gen_file_md5", string);
    }
}

