/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ProgressPane$DefProgressPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.utils.StrUtils;
import javafx.scene.Node;
import org.apache.commons.io.FilenameUtils;

final class GenericInstall$1
extends RInstall {
    GenericInstall$1() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        Installable installable = Procedures.requireInstallable(procedureRunner);
        Log.info("Starting required resource download");
        if (!installable.isNeedDownload()) {
            Log.info("No need to download resources, skip");
            return;
        }
        if (StrUtils.isNullOrEmpty(installable.getDownloadUrl())) {
            throw new InstallException("Download failed: empty or null download url", InstallException$Code.DOWNLOAD_FAILED, "Installable " + installable + " has no download url but it is market as it should have");
        }
        Log.info("Starting download from: " + installable.getDownloadUrl());
        ProgressPane$DefProgressPane progressPane$DefProgressPane = new ProgressPane$DefProgressPane();
        progressPane$DefProgressPane.setContentText(LRes.DOWNLOADING_ROM_FILE.toString() + "\n" + FilenameUtils.getName(installable.getDownloadUrl()));
        UpdateListener updateListener = progressPane$DefProgressPane.getUpdateListener(1000);
        WindowManager.setMainContent((Node)progressPane$DefProgressPane, false);
        try {
            installable.download(updateListener);
            Log.info("Download was success");
        }
        catch (Exception exception) {
            throw new InstallException("Download task failed: " + exception.getMessage(), InstallException$Code.DOWNLOAD_FAILED, exception);
        }
        finally {
            WindowManager.removeTopContent();
        }
    }
}

