/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.adb.AdbCommons;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.procedure.install.StockRecoveryInstall;
import com.xiaomitool.v2.utility.MTPUtils;
import com.xiaomitool.v2.utility.MTPUtils$MTPDevice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

final class StockRecoveryInstall$1
extends RInstall {
    StockRecoveryInstall$1() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        HashMap<String, MTPUtils$MTPDevice> hashMap;
        HashMap<String, MTPUtils$MTPDevice> hashMap2;
        Device device = (Device)procedureRunner.requireContext("selected_device");
        procedureRunner.text(LRes.SEARCHING_CONNECTED_MTP_DEVICES);
        Log.info("Searching MTP devices before mtp enable");
        try {
            hashMap2 = MTPUtils.list();
        }
        catch (IOException iOException) {
            throw new InstallException("MTP list devices failed: " + iOException.getMessage(), InstallException$Code.MTP_FAILED, iOException);
        }
        procedureRunner.text(LRes.MTP_ENABLING_DEVICE);
        Log.info("Enabling MTP on the device");
        String string = AdbCommons.raw(device.getSerial(), "enablemtp:");
        if (string == null) {
            throw new InstallException("Adb enablemtp command failed, maybe your device doesn't support it or device is not connected", InstallException$Code.ADB_EXCEPTION, "Last error: " + AdbCommons.getLastError(device.getSerial()));
        }
        Thread.sleep(2000L);
        procedureRunner.text(LRes.SEARCHING_CONNECTED_MTP_DEVICES);
        Log.info("Searching MTP devices after mtp enable");
        try {
            hashMap = MTPUtils.list();
        }
        catch (IOException iOException) {
            throw new InstallException("MTP list devices failed: " + iOException.getMessage(), InstallException$Code.MTP_FAILED, iOException);
        }
        String string2 = null;
        ArrayList<MTPUtils$MTPDevice> arrayList = new ArrayList<MTPUtils$MTPDevice>();
        for (String object : hashMap.keySet()) {
            if (hashMap2.get(object) == null) {
                Log.info("New MTP device found");
                string2 = object;
            }
            if (object.toLowerCase().contains("vid_2717")) {
                Log.info("New xiaomi MTP device found: " + object);
                arrayList.add(hashMap.get(object));
            }
            Log.info("Skipping MTP device " + object + ", it was already in list");
        }
        if (string2 != null && string2.toLowerCase().contains("vid_2717")) {
            Log.info("Using new MTP device found: " + string2);
            procedureRunner.text(LRes.MTP_DEVICE_SELECTED);
            procedureRunner.setContext("selected_mtp_device", hashMap.get(string2));
            return;
        }
        Log.info("Searching right Xiaomi MTP device by root name == data");
        for (MTPUtils$MTPDevice mTPUtils$MTPDevice : arrayList) {
            try {
                String string3 = MTPUtils.getRoot(mTPUtils$MTPDevice);
                if (string3 == null || !"data".equals(string3.toLowerCase().trim())) continue;
                Log.info("Xiaomi device with data == root name found: " + mTPUtils$MTPDevice.id);
                procedureRunner.text(LRes.MTP_DEVICE_SELECTED);
                procedureRunner.setContext("selected_mtp_device", mTPUtils$MTPDevice);
                return;
            }
            catch (IOException iOException) {
                Log.warn("Cannot get device root of " + mTPUtils$MTPDevice.id + ": " + iOException.getMessage());
            }
        }
        Log.warn("Xiaomi MTP device not found, might be a driver issue");
        Object object = (Integer)procedureRunner.consumeContext("TRIAL");
        if (object == null) {
            object = 0;
        }
        if ((Integer)object < 2) {
            StockRecoveryInstall.fixMtpDevices().run(procedureRunner);
            boolean bl = (Boolean)procedureRunner.consumeContext("FIXMTP");
            if (bl) {
                procedureRunner.setContext("TRIAL", (Integer)object + 1);
                Thread.sleep(1000L);
                this.run(procedureRunner);
                return;
            }
        }
        throw new InstallException("Cannot detect recovery mtp device, try updating the mtp driver on the device", InstallException$Code.MTP_FAILED);
    }
}

