/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ProgressPane$DefProgressPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.tasks.TaskManager;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.MTPUtils;
import com.xiaomitool.v2.utility.MTPUtils$MTPDevice;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.scene.Node;

final class StockRecoveryInstall$3
extends RInstall {
    StockRecoveryInstall$3() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        Installable installable = (Installable)procedureRunner.requireContext("installable");
        File file = installable.getFinalFile();
        if (file == null) {
            throw new InstallException("Null install file", InstallException$Code.INTERNAL_ERROR);
        }
        Path path = file.toPath();
        procedureRunner.text(LRes.MTP_SENDING_FILE);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new InstallException("File " + path.toString() + " doesn't exists!", InstallException$Code.FILE_NOT_FOUND);
        }
        Log.info("Sending file: " + path + " to the device using MTP");
        MTPUtils$MTPDevice mTPUtils$MTPDevice = (MTPUtils$MTPDevice)procedureRunner.requireContext("selected_mtp_device");
        Task task = MTPUtils.getPushTask(mTPUtils$MTPDevice, path, "/");
        ProgressPane$DefProgressPane progressPane$DefProgressPane = new ProgressPane$DefProgressPane();
        progressPane$DefProgressPane.setContentText(LRes.MTP_SENDING_FILE);
        UpdateListener updateListener = progressPane$DefProgressPane.getUpdateListener(150);
        task.setListener(updateListener);
        WindowManager.setMainContent((Node)progressPane$DefProgressPane, false);
        TaskManager.getInstance().startSameThread(task);
        WindowManager.removeTopContent();
        Exception exception = task.getError();
        if (exception != null) {
            throw new InstallException("Failed to send file to mtp device: " + exception.getMessage(), InstallException$Code.MTP_FAILED, exception);
        }
        procedureRunner.text(LRes.FILE_SENT_TO_DEVICE);
        Log.info("File MTP sent to the device succesfully");
    }
}

