/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.adb.AdbCommunication;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ProgressPane$DefProgressPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.rom.Installable;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import javafx.scene.Node;

final class StockRecoveryInstall$5
extends RInstall {
    StockRecoveryInstall$5() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        Device device = Procedures.requireDevice(procedureRunner);
        Installable installable = Procedures.requireInstallable(procedureRunner);
        procedureRunner.text(LRes.MTP_PREPARE_INSTALL);
        Thread.sleep(2000L);
        String string = installable.getInstallToken();
        if (string == null || string.isEmpty()) {
            throw new InstallException("Empty install token", InstallException$Code.MTP_INSTALL_FAILED);
        }
        Log.info("Starting MTP installation");
        Log.info("Install token: " + string);
        AdbRunner adbRunner = new AdbRunner("raw", "mtpinstall:" + string);
        adbRunner.setDeviceSerial(device.getSerial());
        procedureRunner.text(LRes.MTP_INSTALLING_FILE);
        ProgressPane$DefProgressPane progressPane$DefProgressPane = new ProgressPane$DefProgressPane();
        progressPane$DefProgressPane.setProgress(-1.0);
        progressPane$DefProgressPane.setContentText(LRes.MTP_INSTALLING_FILE.toString() + "\n" + LRes.DONT_REBOOT_DEVICE.toString());
        WindowManager.setMainContent((Node)progressPane$DefProgressPane, false);
        LocalDateTime localDateTime = LocalDateTime.now();
        AdbCommunication.getAllAccess();
        try {
            adbRunner.runWait(3600);
        }
        catch (IOException iOException) {
            throw new InstallException("Failed to start mtpinstall process: " + iOException.getMessage(), InstallException$Code.INTERNAL_ERROR, iOException);
        }
        AdbCommunication.giveAllAccess();
        WindowManager.removeTopContent();
        Duration duration = Duration.between(localDateTime, LocalDateTime.now());
        Log.info("MTP installation duration: " + duration.getSeconds() + " seconds");
        if (adbRunner.getExitValue() != 0) {
            throw new InstallException("MtpInstall process returned with code " + adbRunner.getExitValue(), InstallException$Code.MTP_INSTALL_FAILED, adbRunner.getOutputString());
        }
        String string2 = adbRunner.getOutputString();
        string2 = string2 == null ? "" : string2.toLowerCase();
        Log.info("MTP installation output: " + string2);
        if (string2.contains("installation_aborted")) {
            throw new InstallException("MtpInstallation was aborted by the device: probably wrong token", InstallException$Code.MTP_INSTALL_FAILED);
        }
        long l = duration.getSeconds();
        if (l < 8L) {
            throw new InstallException("MtpInstallation took only " + l + " seconds to complete, thus it can't be successful", InstallException$Code.MTP_INSTALL_FAILED, adbRunner.getOutputString());
        }
        procedureRunner.text(LRes.ROM_INSTALLED_ON_DEVICE);
    }
}

