/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.adb.FastbootCommons;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.utility.utils.StrUtils;

final class TwrpInstall$1
extends RInstall {
    TwrpInstall$1() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        Installable installable = Procedures.requireInstallable(procedureRunner);
        Device device = Procedures.requireDevice(procedureRunner);
        procedureRunner.text(LRes.FLASHING_STUFF.toString(LRes.TWRP_RECOVERY.toString()));
        Log.info("Flashing recovery via fastboot, file: " + installable.getFinalFile());
        String string = FastbootCommons.flash(device.getSerial(), installable.getFinalFile(), "recovery");
        if ("err:anti-rollback".equals(string)) {
            Log.warn("Anti rollback protection detected, flashing dummy");
            FastbootCommons.flashDummy(device.getSerial());
            string = FastbootCommons.flash(device.getSerial(), installable.getFinalFile(), "recovery");
        }
        if (string == null || string.startsWith("err:")) {
            throw new InstallException(new AdbException("Fastboot flash recovery failed, output:" + StrUtils.str(string)));
        }
        procedureRunner.text(LRes.BOOTING_STUFF.toString(LRes.TWRP_RECOVERY.toString()));
        Log.info("Booting bootable via fastboot, file: " + installable.getFinalFile());
        FastbootCommons.boot(device.getSerial(), installable.getFinalFile());
        Thread.sleep(3000L);
        device.setConnected(false);
    }
}

