/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.process;

import java.io.InputStream;
import java.util.LinkedList;

public class LineScanner {
    private final LinkedList<String> linesBuffer = new LinkedList();
    private final byte[] buffer = new byte[1024];
    private InputStream inputStream;
    private boolean isFinished = false;
    private StringBuilder builder;

    public LineScanner(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean hasNextLine() {
        if (!this.linesBuffer.isEmpty()) {
            return true;
        }
        if (this.builder != null) {
            return true;
        }
        if (this.isFinished) {
            return false;
        }
        while (!this.isFinished && this.linesBuffer.isEmpty()) {
            this.read();
        }
        return this.hasNextLine();
    }

    private void read() {
        int n = this.inputStream.read(this.buffer);
        if (n <= 0) {
            this.isFinished = true;
            return;
        }
        String string = new String(this.buffer, 0, n);
        String[] stringArray = string.split("(\\r|\\n)");
        if (this.builder != null) {
            this.builder.append(stringArray[0]);
            if (stringArray.length > 1) {
                stringArray[0] = this.builder.toString();
            }
        }
        this.builder = new StringBuilder(stringArray[stringArray.length - 1]);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            this.linesBuffer.add(stringArray[i]);
        }
    }

    public String nextLine() {
        if (!this.linesBuffer.isEmpty()) {
            return this.linesBuffer.pollFirst();
        }
        if (this.isFinished) {
            if (this.builder != null) {
                String string = this.builder.toString();
                this.builder = null;
                return string;
            }
            return null;
        }
        while (!this.isFinished && this.linesBuffer.isEmpty()) {
            this.read();
        }
        return this.nextLine();
    }
}

