/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.process;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.ProcessRunner$1;
import com.xiaomitool.v2.process.ProcessRunner$ProcessStatus;
import com.xiaomitool.v2.utility.RunnableWithArg;
import com.xiaomitool.v2.utility.Thrower;
import com.xiaomitool.v2.utility.WaitSemaphore;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ProcessRunner {
    private static int processNumber = 0;
    private final WaitSemaphore readFinishedSemaphore = new WaitSemaphore(0);
    private final List<RunnableWithArg> syncCallbacks = Collections.synchronizedList(new ArrayList());
    protected Path executable;
    protected LinkedList<String> arguments;
    protected boolean isFeedback = true;
    protected List<String> outputBuffer = Collections.synchronizedList(new LinkedList());
    private int secondsTimeout = 1800;
    private Process runningProcess = null;
    private int exitValue = 0;
    private ProcessRunner$ProcessStatus status = ProcessRunner$ProcessStatus.READY;
    private File workingDir;
    private int pNum = -1;
    private Thrower<IOException> IOThrower;

    public ProcessRunner(Path path) {
        this(path, null);
    }

    public ProcessRunner(String string, String[] stringArray) {
        this(Paths.get(string, new String[0]), stringArray);
    }

    public ProcessRunner(String string) {
        this(Paths.get(string, new String[0]));
    }

    public ProcessRunner(Path path, String[] stringArray) {
        this.executable = path;
        this.arguments = new LinkedList();
        if (stringArray != null) {
            this.arguments.addAll(Arrays.asList(stringArray));
        }
    }

    public void setWorkingDir(File file) {
        this.workingDir = file;
    }

    private void setStatus(ProcessRunner$ProcessStatus processRunner$ProcessStatus) {
        this.status = processRunner$ProcessStatus;
    }

    public Process start() {
        List<String> list = this.buildFinalArgumentsList();
        StringBuilder stringBuilder = new StringBuilder();
        for (String object2 : list) {
            stringBuilder.append(" ").append('\"').append(object2).append('\"');
        }
        this.pNum = ++processNumber;
        Log.log("PSTA", "Start process (" + processNumber + "):" + stringBuilder.toString(), true);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        if (this.workingDir != null) {
            processBuilder.directory(this.workingDir);
        }
        Process process = processBuilder.start();
        this.IOThrower = new Thrower();
        InputStream inputStream = process.getInputStream();
        new Thread(new ProcessRunner$1(this, inputStream)).start();
        this.setStatus(ProcessRunner$ProcessStatus.RUNNING);
        this.runningProcess = process;
        return this.runningProcess;
    }

    protected List<String> buildFinalArgumentsList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.executable.toString());
        linkedList.addAll(this.arguments);
        return linkedList;
    }

    public boolean kill() {
        if (!this.isAlive()) {
            return false;
        }
        this.runningProcess.destroy();
        return true;
    }

    public boolean isAlive() {
        return !ProcessRunner$ProcessStatus.RUNNING.equals((Object)this.status) || this.runningProcess == null || !this.runningProcess.isAlive();
    }

    private String manageLineOutput(String string) {
        return string;
    }

    public int runWait(int n) {
        Process process = null;
        process = this.status != ProcessRunner$ProcessStatus.RUNNING || this.runningProcess == null ? this.start() : this.runningProcess;
        this.IOThrower.check();
        try {
            if (!process.waitFor(n, TimeUnit.SECONDS)) {
                throw new InterruptedException("Process didn't exited before timeout");
            }
            this.IOThrower.check();
            this.setStatus(ProcessRunner$ProcessStatus.FINISHED);
            this.exitValue = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            Log.error("Process (" + this.pNum + ") wait timeout (" + n + ") or interrupted: " + interruptedException.getMessage());
            this.exitValue = -1;
            this.setStatus(ProcessRunner$ProcessStatus.EXCEPTION);
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
        Log.info("Process (" + this.pNum + ") ended with exit code: " + this.exitValue + ", output len: " + StrUtils.lenght(this.getOutputString()));
        return this.exitValue;
    }

    public int runWait() {
        return this.runWait(this.secondsTimeout);
    }

    public void addSyncCallback(RunnableWithArg runnableWithArg) {
        this.syncCallbacks.add(runnableWithArg);
    }

    public void addArgument(String string) {
        this.arguments.addLast(string);
    }

    public String getOutputString() {
        this.waitOutputReadFinished();
        return String.join((CharSequence)"\n", this.outputBuffer);
    }

    public List<String> getOutputLines() {
        this.waitOutputReadFinished();
        return new LinkedList<String>(this.outputBuffer);
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private boolean waitOutputReadFinished() {
        try {
            this.readFinishedSemaphore.waitOnce(4);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    static /* synthetic */ WaitSemaphore access$000(ProcessRunner processRunner) {
        return processRunner.readFinishedSemaphore;
    }

    static /* synthetic */ String access$100(ProcessRunner processRunner, String string) {
        return processRunner.manageLineOutput(string);
    }

    static /* synthetic */ int access$200(ProcessRunner processRunner) {
        return processRunner.pNum;
    }

    static /* synthetic */ List access$300(ProcessRunner processRunner) {
        return processRunner.syncCallbacks;
    }
}

