/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.resources;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager$1;
import com.xiaomitool.v2.utility.utils.FileUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.image.Image;
import org.apache.commons.codec.binary.Base64InputStream;

public class ResourcesManager {
    private static final String TMP_DIR = "tmp";
    private static final String RESOURCE_DIR = "res";
    private static final String TOOLS_DIR = "tools";
    private static final String DRIVER_DIR = "driver";
    private static final String LANG_DIR = "lang";
    private static final String ADB_EXE = "adb";
    private static final String FASTBOOT_EXE = "fastboot";
    private static final String XIAOMITOOL_JAR = "XiaoMiTool.jar";
    private static final Path[] FASTBOOT_FILES_WIN = new Path[]{ResourcesManager.getToolPath("AdbWinApi.dll", false), ResourcesManager.getToolPath("AdbWinUsbApi.dll", false), ResourcesManager.getToolPath("fastboot.exe", true), ResourcesManager.getToolPath("libwinpthread-1.dll", false)};
    private static final Path[] FASTBOOT_FILES_MAC_LIN = new Path[]{ResourcesManager.getToolPath("fastboot")};
    private static final Integer TMP_DIR_SYNC = 1;
    private static Path tmpPath;
    private static Boolean initStatus;
    private static Path currentPath;
    private static final Path DEFAULT_DOWNLAOD_PATH;
    private static Path currentJarDirPath;
    private static Path currentJarPath;
    private static Boolean quickUpdateSupported;
    private static Path javaLaunchExe;
    private static Path ANDROID_INF_PATH;

    public static Path[] getFastbootFilesPath() {
        if (ResourcesConst.isWindows()) {
            return FASTBOOT_FILES_WIN;
        }
        return FASTBOOT_FILES_MAC_LIN;
    }

    public static void copyResourcesToDir(Path[] pathArray, Path path) {
        for (Path path2 : pathArray) {
            Files.copy(path2, path.resolve(path2.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static Path getSystemTmpPath() {
        if (tmpPath == null) {
            String string = System.getProperty("java.io.tmpdir");
            if (StrUtils.isNullOrEmpty(string)) {
                return ResourcesManager.getTmpPath();
            }
            Path path = Paths.get(string, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return ResourcesManager.getTmpPath();
            }
            tmpPath = path.resolve("xiaomitool2");
            if (!Files.exists(tmpPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(tmpPath, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    Log.error("Failed to create tmp directory");
                    tmpPath = null;
                    return ResourcesManager.getTmpPath();
                }
            }
        }
        return tmpPath;
    }

    public static boolean init() {
        if (initStatus == null) {
            Path path = ResourcesManager.getXiaomitoolPath();
            boolean bl = ResourcesManager.setCurrentPath(path);
            boolean bl2 = ResourcesManager.findWritableTmpDir();
            Log.info("Temporary dir used: " + ResourcesManager.getTmpPath());
            initStatus = bl2 && bl;
        }
        return initStatus;
    }

    private static Path getXiaomitoolPath() {
        Path path = ResourcesManager.getCurrentJarDirPath();
        if (ResourcesManager.verifyWorkingDirectoryGood(path)) {
            return path;
        }
        Log.warn("Path not valid working dir:" + path);
        path = Paths.get(".", new String[0]);
        if (ResourcesManager.verifyWorkingDirectoryGood(path)) {
            return path;
        }
        Log.warn("Path not valid working dir:" + path);
        try {
            Path path2 = FileUtils.searchFile(ResourcesManager.getCurrentPath(), ResourcesConst.getOSExe(ADB_EXE), false, 4);
            path = path2.getParent().getParent().getParent();
            if (ResourcesManager.verifyWorkingDirectoryGood(path)) {
                return path;
            }
            Log.warn("Path not valid working dir:" + path);
        }
        catch (Throwable throwable) {
            Log.warn("Path failed check working dir:" + throwable.getMessage());
        }
        return null;
    }

    private static boolean setCurrentPath(Path path) {
        currentPath = path;
        if (path != null) {
            // empty if block
        }
        return path != null;
    }

    private static boolean verifyWorkingDirectoryGood(Path path) {
        if (path == null) {
            return false;
        }
        Path path2 = path.resolve(XIAOMITOOL_JAR);
        Path path3 = path.resolve(RESOURCE_DIR).resolve(TOOLS_DIR).resolve(ResourcesConst.getOSExe(ADB_EXE));
        if (!Files.exists(path2, new LinkOption[0])) {
            Log.warn("Path not exists: " + path2);
            return false;
        }
        if (!Files.exists(path3, new LinkOption[0])) {
            Log.warn("Path not exists: " + path3);
            return false;
        }
        return true;
    }

    public static Path getCurrentPath() {
        if (currentPath == null) {
            currentPath = Paths.get(".", new String[0]);
        }
        return currentPath;
    }

    public static Path getResourcesPath() {
        return ResourcesManager.getCurrentPath().resolve(RESOURCE_DIR);
    }

    public static Path getToolsPath() {
        return ResourcesManager.getResourcesPath().resolve(TOOLS_DIR);
    }

    public static Path getToolPath(String string) {
        return ResourcesManager.getToolPath(string, true);
    }

    public static Path getToolPath(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl) {
            String string2 = ResourcesConst.getOSExeExtension();
            if (!string.toLowerCase().endsWith(string2)) {
                string = string + string2;
            }
        }
        return ResourcesManager.getToolsPath().resolve(string);
    }

    public static Path getAdbPath() {
        return ResourcesManager.getToolPath(ADB_EXE, true);
    }

    public static Path getFastbootPath() {
        return ResourcesManager.getToolPath(FASTBOOT_EXE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getTmpPath() {
        Integer n = TMP_DIR_SYNC;
        synchronized (n) {
            if (tmpPath == null) {
                Path path = ResourcesManager.getResourcesPath().resolve(TMP_DIR);
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        return ResourcesManager.getResourcesPath();
                    }
                }
                tmpPath = path;
            }
            return tmpPath;
        }
    }

    public static Path getLangPath() {
        return ResourcesManager.getTmpPath().resolve(LANG_DIR);
    }

    public static Path getLangFilePath(String string) {
        return ResourcesManager.getLangPath().resolve(string + ".xml");
    }

    public static Path getDriverPath() {
        return ResourcesManager.getResourcesPath().resolve(DRIVER_DIR);
    }

    public static List<Path> getAllInfPaths() {
        Stream<Path> stream = Files.find(ResourcesManager.getDriverPath(), 3, new ResourcesManager$1(), new FileVisitOption[0]);
        return stream.collect(Collectors.toList());
    }

    public static Image b64toImage(byte[] byArray) {
        return new Image((InputStream)new Base64InputStream(new ByteArrayInputStream(byArray), false));
    }

    public static Path getLogPath() {
        return ResourcesManager.getTmpPath().resolve("logs");
    }

    public static Path getCurrentJarDirPath() {
        if (currentJarDirPath == null) {
            Path path;
            try {
                path = ResourcesManager.getCurrentJarPath();
                if (Files.exists(path.getParent(), new LinkOption[0])) {
                    currentJarDirPath = path.getParent();
                }
                Log.info("Current jar dir path: " + currentJarDirPath);
            }
            catch (Exception exception) {
                Log.error("Failed to find current jar dir path: " + exception.getMessage());
            }
            if (currentJarDirPath == null && (path = ResourcesManager.getXiaomitoolPath()) != null && Files.exists(path.resolve(XIAOMITOOL_JAR), new LinkOption[0])) {
                currentJarDirPath = path;
            }
        }
        return currentJarDirPath;
    }

    public static Path getCurrentJarPath() {
        if (currentJarPath == null) {
            Path path;
            try {
                path = Paths.get(ResourcesManager.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (Files.exists(path, new LinkOption[0])) {
                    currentJarPath = path;
                }
                Log.info("Current jar path: " + currentJarPath);
            }
            catch (Exception exception) {
                Log.error("Failed to find current jar path: " + exception.getMessage());
            }
            if (currentJarPath == null && (path = ResourcesManager.getXiaomitoolPath()) != null && !Files.exists(currentJarPath = path.resolve(XIAOMITOOL_JAR), new LinkOption[0])) {
                currentJarPath = null;
            }
        }
        return currentJarPath;
    }

    public static boolean isQuickUpdatedSupported() {
        if (quickUpdateSupported == null) {
            Path path = ResourcesManager.getCurrentJarDirPath();
            quickUpdateSupported = path != null && ResourcesManager.getJavaLaunchExe() != null && ResourcesManager.checkIfWritable(path);
            Log.info("Quick update supported: " + quickUpdateSupported);
        }
        return quickUpdateSupported;
    }

    public static Path getJavaLaunchExe() {
        return ResourcesManager.getJavaLaunchExe(ResourcesConst.isWindows() ? "javaw.exe" : "java");
    }

    public static Path getJavaLaunchExe(String string) {
        Path path;
        if (javaLaunchExe == null) {
            try {
                path = ResourcesManager.getCurrentJarDirPath();
                if (path != null) {
                    Path path2 = path.resolve("bin").resolve(string);
                    if (Files.exists(path2, new LinkOption[0])) {
                        javaLaunchExe = path2;
                    } else {
                        Log.warn("Java launch path not existing: " + path2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.info("Java launch path: " + javaLaunchExe);
        }
        if (javaLaunchExe == null) {
            try {
                javaLaunchExe = FileUtils.searchFile(ResourcesManager.getCurrentPath(), string, false, 4);
                if (javaLaunchExe == null) {
                    throw new Exception("not found");
                }
            }
            catch (Throwable throwable) {
                Log.warn("Java launch path not in current path: " + throwable.getMessage());
            }
        }
        if (javaLaunchExe == null) {
            try {
                path = ResourcesManager.getCurrentPath().normalize().getParent();
                if (path == null) {
                    throw new Exception("null parent");
                }
                javaLaunchExe = FileUtils.searchFile(path, string, false, 4);
                if (javaLaunchExe == null) {
                    throw new Exception("not found");
                }
            }
            catch (Throwable throwable) {
                Log.warn("Java launch path not in parent path: " + throwable.getMessage());
            }
        }
        return javaLaunchExe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean findWritableTmpDir() {
        Integer n = TMP_DIR_SYNC;
        synchronized (n) {
            try {
                Path path = ResourcesManager.getTmpPath();
                if (ResourcesManager.checkIfWritable(path)) {
                    tmpPath = path;
                    return true;
                }
                Log.warn("Standard tmp path is not writable, trying java.io.tmpdir");
                path = FileUtils.toCanonical(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("xiaomitool_v2"));
                if (path != null && !Files.exists(path, new LinkOption[0])) {
                    path.toFile().mkdirs();
                }
                if (ResourcesManager.checkIfWritable(path)) {
                    tmpPath = path;
                    return true;
                }
                Log.warn("Failed to get tmp dir: no valid dir found");
                return false;
            }
            catch (Throwable throwable) {
                Log.warn("Failed to get tmp dir: " + throwable.getMessage());
                return false;
            }
        }
    }

    private static boolean checkIfWritable(Path path) {
        if (path == null) {
            return false;
        }
        try {
            Path path2 = path.resolve(StrUtils.randomWord(16));
            FileUtils.writeAll(path2.toFile(), "test");
            Files.delete(path2);
            return true;
        }
        catch (Throwable throwable) {
            Log.warn("Path not writable: " + throwable.getMessage());
            Log.printStackTrace(throwable);
            return false;
        }
    }

    public static Path getAndroidDriverPath() {
        if (ANDROID_INF_PATH == null) {
            List<Path> list = ResourcesManager.getAllInfPaths();
            for (Path path : list) {
                if (!String.valueOf(path).toLowerCase().contains("android_winusb.inf")) continue;
                ANDROID_INF_PATH = path;
            }
        }
        if (ANDROID_INF_PATH == null) {
            throw new IOException("Failed to find the android driver path");
        }
        return ANDROID_INF_PATH;
    }

    static {
        initStatus = null;
        DEFAULT_DOWNLAOD_PATH = ResourcesManager.getResourcesPath().resolve("downloads");
        quickUpdateSupported = null;
        javaLaunchExe = null;
        ANDROID_INF_PATH = null;
    }
}

