/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.gui.visual.ChooserPane$Choice;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.rom.Installable$1;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.RomException;
import com.xiaomitool.v2.rom.interfaces.InstallObject;
import com.xiaomitool.v2.tasks.DownloadTask;
import com.xiaomitool.v2.tasks.TaskManager;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.Choiceable;
import com.xiaomitool.v2.utility.CommandClass;
import com.xiaomitool.v2.utility.WaitSemaphore;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.xiaomi.miuithings.Codebase;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import java.io.File;

public abstract class Installable
extends CommandClass
implements InstallObject,
Choiceable {
    protected String md5;
    protected String downloadUrl;
    protected String installToken;
    protected String extraParam;
    protected String unique;
    protected Codebase codebase;
    protected MiuiVersion miuiVersion;
    protected File downloadedFile;
    protected File finalFile;
    protected Installable$Type type;
    protected boolean isOfficial;
    protected boolean needDownload = false;
    protected boolean needExtraction = false;
    private boolean isFake = false;
    private WaitSemaphore resourceReady = new WaitSemaphore();
    private Thread fetchResourceThread = null;
    private Exception lastException = null;
    private String downloadFilename = null;

    public Installable(Installable$Type installable$Type, boolean bl, String string, boolean bl2, boolean bl3) {
        this.type = installable$Type;
        this.isOfficial = bl;
        this.unique = string;
        this.needDownload = bl2;
        this.needExtraction = bl3;
    }

    public Installable(Installable$Type installable$Type, boolean bl, String string, boolean bl2, boolean bl3, String string2) {
        this(installable$Type, bl, string, bl2, bl3);
        this.downloadUrl = string2;
    }

    public Installable(Installable$Type installable$Type, boolean bl, String string, boolean bl2, boolean bl3, File file) {
        this(installable$Type, bl, string, bl2, bl3);
        this.downloadedFile = file;
    }

    public boolean isFake() {
        return this.isFake;
    }

    protected void setFake(boolean bl) {
        this.isFake = bl;
    }

    public Installable$Type getType() {
        return this.type;
    }

    public Codebase getCodebase() {
        return this.codebase;
    }

    public boolean isOfficial() {
        return this.isOfficial;
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public MiuiVersion getMiuiVersion() {
        return this.miuiVersion;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getInstallToken() {
        return this.installToken;
    }

    public boolean hasInstallToken() {
        return this.installToken != null && !this.installToken.isEmpty();
    }

    public String getMd5() {
        return this.md5;
    }

    public String getExtraParam() {
        return this.extraParam;
    }

    protected String getUniqueId() {
        return this.unique;
    }

    public final String getUnique() {
        return this.getClass().getName() + this.getUniqueId();
    }

    public int hashCode() {
        return this.getUnique().hashCode();
    }

    public boolean isNeedDownload() {
        return this.needDownload;
    }

    public boolean isNeedExtraction() {
        if (!this.needExtraction && this.finalFile == null && this.downloadedFile != null) {
            this.finalFile = this.downloadedFile;
        }
        return this.needExtraction;
    }

    protected String getDownloadFilename() {
        return this.downloadFilename;
    }

    public void setDownloadFilename(String string) {
        this.downloadFilename = string;
    }

    protected Object downloadInternal(UpdateListener updateListener) {
        if (this.getDownloadUrl() == null) {
            throw new RomException("Missing download url");
        }
        DownloadTask downloadTask = new DownloadTask(updateListener, this.getDownloadUrl(), this.downloadFilename == null ? null : SettingsUtils.getDownloadFile(this.downloadFilename));
        TaskManager.getInstance().startSameThread(downloadTask);
        if (!downloadTask.isFinished()) {
            throw new RomException("Failed to download file: " + (downloadTask.getError() != null ? downloadTask.getError().getMessage() : "null error"));
        }
        this.downloadedFile = (File)downloadTask.getResult();
        return this.downloadedFile;
    }

    public Object download(UpdateListener updateListener) {
        if (!this.isNeedDownload()) {
            return null;
        }
        if (this.downloadedFile != null) {
            return this.downloadedFile;
        }
        return this.downloadInternal(updateListener);
    }

    public Object extract(UpdateListener updateListener) {
        if (!this.isNeedExtraction()) {
            return null;
        }
        if (this.finalFile != null) {
            return this.finalFile;
        }
        return this.extractInternal(updateListener);
    }

    @Override
    public String toLogString() {
        return this.getClass().getSimpleName() + " - " + StrUtils.str((Object)this.getType()) + "[url:" + StrUtils.str(this.downloadUrl) + ",dl:" + StrUtils.str(this.downloadedFile) + ",final:" + StrUtils.str(this.finalFile) + "]";
    }

    public void fetchResources(UpdateListener updateListener, UpdateListener updateListener2) {
        if (this.fetchResourceThread != null && this.fetchResourceThread.isAlive()) {
            return;
        }
        this.resourceReady.setPermits(0);
        this.lastException = null;
        Installable$1 installable$1 = new Installable$1(this, updateListener2, updateListener);
        this.fetchResourceThread = new Thread(installable$1);
        this.fetchResourceThread.start();
    }

    public void waitReourcesReady() {
        this.resourceReady.waitOnce();
        if (this.lastException != null) {
            throw this.lastException;
        }
    }

    protected Object extractInternal(UpdateListener updateListener) {
        this.setFinalFile(this.downloadedFile);
        return this.downloadedFile;
    }

    protected void setVars(Installable$Type installable$Type, boolean bl, String string, boolean bl2, boolean bl3) {
        this.type = installable$Type;
        this.isOfficial = bl;
        this.unique = string;
        this.needDownload = bl2;
        this.needExtraction = bl3;
    }

    public File getFinalFile() {
        return this.finalFile;
    }

    protected void setFinalFile(File file) {
        this.finalFile = file;
    }

    @Override
    public abstract RInstall getInstallProcedure();

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public final ChooserPane$Choice getChoice() {
        return new ChooserPane$Choice(this.getTitle(), this.getText(), this.getIcon());
    }

    @Override
    public final Installable$Type getInstallType() {
        return this.type;
    }

    public Installable orig() {
        return this;
    }

    static /* synthetic */ WaitSemaphore access$000(Installable installable) {
        return installable.resourceReady;
    }

    static /* synthetic */ Exception access$102(Installable installable, Exception exception) {
        installable.lastException = exception;
        return installable.lastException;
    }
}

