/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.adb.device.DeviceGroups;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.rom.MiuiRom;
import com.xiaomitool.v2.utility.utils.SettingsUtils$Region;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.xiaomi.f;
import com.xiaomitool.v2.xiaomi.miuithings.Branch;
import java.util.LinkedHashSet;

public enum MiuiRom$Specie {
    CHINA_STABLE(0, SettingsUtils$Region.CN, LRes.CHINA_STABLE),
    CHINA_DEVELOPER(1, SettingsUtils$Region.CN, LRes.CHINA_DEVELOPER),
    GLOBAL_STABLE(2, SettingsUtils$Region.GLOBAL, LRes.GLOBAL_STABLE),
    GLOBAL_DEVELOPER(3, SettingsUtils$Region.GLOBAL, LRes.GLOBAL_DEVELOPER),
    EUROPEAN_STABLE(4, SettingsUtils$Region.EU, LRes.EUROPE_STABLE),
    EUROPEAN_DEVELOPER(5, SettingsUtils$Region.EU, LRes.EUROPE_DEVELOPER),
    INDIA_STABLE(6, SettingsUtils$Region.INDIA, LRes.INDIA_STABLE),
    INDIA_DEVELOPER(7, SettingsUtils$Region.INDIA, LRes.INDIA_DEVELOPER),
    RUSSIA_STABLE(8, SettingsUtils$Region.RUSSIA, LRes.RUSSIA_STABLE),
    RUSSIA_DEVELOPER(9, SettingsUtils$Region.RUSSIA, LRes.RUSSIA_DEVELOPER),
    OTHER(100, SettingsUtils$Region.OTHER, LRes.REG_OTHER);

    private final int code;
    private final LRes lRes;
    private Branch branch;
    private SettingsUtils$Region parentRegion;
    private String suffix;

    private MiuiRom$Specie(int n2, SettingsUtils$Region settingsUtils$Region, LRes lRes) {
        this.suffix = settingsUtils$Region.getSuffix();
        this.code = n2;
        this.parentRegion = settingsUtils$Region;
        this.lRes = lRes;
    }

    public static MiuiRom$Specie fromZoneBranch(SettingsUtils$Region settingsUtils$Region, Branch branch) {
        for (MiuiRom$Specie miuiRom$Specie : MiuiRom$Specie.values()) {
            if (!miuiRom$Specie.getParentRegion().equals((Object)settingsUtils$Region) || !miuiRom$Specie.getBranch().equals((Object)branch)) continue;
            return miuiRom$Specie;
        }
        MiuiRom$Specie miuiRom$Specie = OTHER;
        miuiRom$Specie.parentRegion = settingsUtils$Region;
        miuiRom$Specie.branch = branch;
        return miuiRom$Specie;
    }

    public static LinkedHashSet<MiuiRom$Specie> listToSearchSpecies(SettingsUtils$Region settingsUtils$Region, String string) {
        LinkedHashSet<MiuiRom$Specie> linkedHashSet = new LinkedHashSet<MiuiRom$Specie>();
        linkedHashSet.add(CHINA_STABLE);
        linkedHashSet.add(CHINA_DEVELOPER);
        linkedHashSet.add(GLOBAL_STABLE);
        linkedHashSet.add(GLOBAL_DEVELOPER);
        if (!DeviceGroups.isMultiRegionDevice(string)) {
            return linkedHashSet;
        }
        MiuiRom$Specie miuiRom$Specie = MiuiRom$Specie.fromStringBranch(string, Branch.STABLE);
        for (MiuiRom$Specie miuiRom$Specie2 : MiuiRom$Specie.values()) {
            if (!miuiRom$Specie2.parentRegion.equals((Object)settingsUtils$Region)) continue;
            linkedHashSet.add(miuiRom$Specie2);
        }
        if (DeviceGroups.hasEEARegion(string)) {
            linkedHashSet.add(EUROPEAN_STABLE);
            linkedHashSet.add(EUROPEAN_DEVELOPER);
        }
        if (miuiRom$Specie != null) {
            linkedHashSet.add(miuiRom$Specie);
        }
        linkedHashSet.removeAll(MiuiRom.access$000());
        return linkedHashSet;
    }

    public static MiuiRom$Specie fromCode(int n) {
        for (MiuiRom$Specie miuiRom$Specie : MiuiRom$Specie.values()) {
            if (miuiRom$Specie.code != n) continue;
            return miuiRom$Specie;
        }
        return null;
    }

    public static MiuiRom$Specie fromStringBranch(String string, Branch branch) {
        if (branch == null || string == null) {
            return null;
        }
        MiuiRom$Specie miuiRom$Specie = MiuiRom$Specie.baseSpecieFromCodename(string);
        if (OTHER.equals((Object)miuiRom$Specie)) {
            miuiRom$Specie.setBranch(branch);
            return miuiRom$Specie;
        }
        int n = Branch.STABLE.equals((Object)branch.getDual()) ? 0 : 1;
        MiuiRom$Specie miuiRom$Specie2 = MiuiRom$Specie.fromCode(n + miuiRom$Specie.code);
        if (miuiRom$Specie2 == null) {
            return null;
        }
        miuiRom$Specie2.setBranch(branch);
        return miuiRom$Specie2;
    }

    private static MiuiRom$Specie baseSpecieFromCodename(String string) {
        if (string == null) {
            return null;
        }
        String string2 = f.c(string);
        String string3 = StrUtils.after(string, string2);
        if (string3 == null) {
            return null;
        }
        for (MiuiRom$Specie miuiRom$Specie : MiuiRom$Specie.values()) {
            if (!string3.equalsIgnoreCase(miuiRom$Specie.suffix) || miuiRom$Specie.equals((Object)OTHER)) continue;
            return miuiRom$Specie.toStable();
        }
        MiuiRom$Specie miuiRom$Specie = OTHER;
        miuiRom$Specie.suffix = string3;
        return miuiRom$Specie;
    }

    public static int getZone(String string) {
        if (string == null) {
            return 0;
        }
        MiuiRom$Specie miuiRom$Specie = MiuiRom$Specie.fromStringBranch(string, Branch.STABLE);
        return miuiRom$Specie.getZone();
    }

    public String getFastbootRegion() {
        return this.parentRegion.getFastbootValue();
    }

    public String getDrawable() {
        return this.parentRegion == null ? SettingsUtils$Region.GLOBAL.getDrawable() : this.parentRegion.getDrawable();
    }

    public SettingsUtils$Region getParentRegion() {
        return this.parentRegion;
    }

    public int getCode() {
        return this.code;
    }

    public Branch getBranch() {
        if (this.branch != null) {
            return this.branch;
        }
        return this.code % 2 == 0 ? Branch.STABLE : Branch.DEVELOPER;
    }

    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    public String buildModDevice(String string) {
        String string2 = f.c(string);
        return string2 + this.suffix;
    }

    public MiuiRom$Specie toChina() {
        return this.toRegion(SettingsUtils$Region.CN);
    }

    public MiuiRom$Specie toGlobal() {
        return this.toRegion(SettingsUtils$Region.GLOBAL);
    }

    public MiuiRom$Specie toRegion(SettingsUtils$Region settingsUtils$Region) {
        for (MiuiRom$Specie miuiRom$Specie : MiuiRom$Specie.values()) {
            if (!miuiRom$Specie.parentRegion.equals((Object)settingsUtils$Region)) continue;
            int n = miuiRom$Specie.code;
            int n2 = this.code % 2;
            return MiuiRom$Specie.fromCode(n + n2);
        }
        return null;
    }

    public boolean isChinese() {
        return SettingsUtils$Region.CN.equals((Object)this.parentRegion);
    }

    public MiuiRom$Specie toStable() {
        return MiuiRom$Specie.fromCode(this.code - this.code % 2);
    }

    public MiuiRom$Specie toDeveloper() {
        return MiuiRom$Specie.fromCode(1 + this.code - this.code % 2);
    }

    public boolean isStable() {
        return this.code % 2 == 0;
    }

    public MiuiRom$Specie toOppositeBranch() {
        if (this.isStable()) {
            return this.toDeveloper();
        }
        return this.toStable();
    }

    public MiuiRom$Specie toBranch(Branch branch) {
        if (branch == null) {
            return this;
        }
        return branch.equals((Object)Branch.STABLE) ? this.toStable() : this.toDeveloper();
    }

    public String toHuman() {
        return this.lRes.toString();
    }

    public String toString() {
        return super.toString() + "(" + this.suffix + ")";
    }

    public int getZone() {
        return this.isChinese() ? 1 : 2;
    }
}

