/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.RNode;
import com.xiaomitool.v2.procedure.install.GenericInstall;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.MultiInstallable$1;
import com.xiaomitool.v2.tasks.UpdateListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Objects;

public abstract class MultiInstallable
extends Installable {
    private Installable[] children;
    private int currentId = 0;

    public MultiInstallable(Installable ... installableArray) {
        super(Installable$Type.MULTI, MultiInstallable.isOfficial(installableArray), MultiInstallable.unique(installableArray), true, true);
        this.children = installableArray;
    }

    private static boolean isOfficial(Installable ... installableArray) {
        boolean bl = true;
        for (Installable installable : installableArray) {
            bl &= installable.isOfficial();
        }
        return bl;
    }

    private static String unique(Installable ... installableArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Installable installable : installableArray) {
            stringBuilder.append(installable.getUniqueId());
        }
        return stringBuilder.toString();
    }

    public void setCurrentId(int n) {
        this.currentId = n;
        this.setFinalFile(null);
        this.downloadedFile = null;
    }

    public Installable[] getChildren() {
        return this.children;
    }

    @Override
    public RInstall getInstallProcedure() {
        RInstall[] rInstallArray = new RInstall[this.children.length * 2 - 1];
        int n = 0;
        int n2 = 0;
        for (Installable installable : this.children) {
            int n3 = ++n2;
            if (n >= rInstallArray.length) break;
            rInstallArray[n++] = installable.getInstallProcedure();
            if (n > rInstallArray.length - 2) continue;
            rInstallArray[n++] = RNode.sequence(new MultiInstallable$1(this, n3), Objects.equals((Object)this.children[n2 - 1].getInstallType(), (Object)this.children[n2].getInstallType()) ? Procedures.doNothing() : GenericInstall.satisfyAllRequirements(), GenericInstall.resourceFetchWait());
        }
        return RNode.sequence(rInstallArray);
    }

    @Override
    public LinkedHashSet<Device$Status> getRequiredStates() {
        LinkedHashSet<Device$Status> linkedHashSet = new LinkedHashSet<Device$Status>();
        for (Installable installable : this.children) {
            LinkedHashSet<Device$Status> linkedHashSet2 = installable.getRequiredStates();
            if (linkedHashSet2 == null) continue;
            linkedHashSet.addAll(linkedHashSet2);
        }
        return linkedHashSet;
    }

    @Override
    protected Object downloadInternal(UpdateListener updateListener) {
        Installable installable = this.children[this.currentId];
        if (!installable.needDownload) {
            if (installable.downloadedFile != null) {
                return installable.downloadedFile;
            }
            if (installable.getFinalFile() != null) {
                return installable.getFinalFile();
            }
            return null;
        }
        return this.getCurrentChild().downloadInternal(updateListener);
    }

    @Override
    protected Object extractInternal(UpdateListener updateListener) {
        Installable installable = this.children[this.currentId];
        if (!installable.needExtraction) {
            if (installable.getFinalFile() != null) {
                return installable.getFinalFile();
            }
            if (installable.downloadedFile != null) {
                installable.setFinalFile(installable.downloadedFile);
                return installable.getFinalFile();
            }
            return null;
        }
        return this.getCurrentChild().extractInternal(updateListener);
    }

    @Override
    public String getDownloadUrl() {
        return this.getCurrentChild().getDownloadUrl();
    }

    @Override
    public File getFinalFile() {
        return this.getCurrentChild().getFinalFile();
    }

    @Override
    public File getDownloadedFile() {
        return this.getCurrentChild().getDownloadedFile();
    }

    @Override
    public boolean isNeedDownload() {
        return this.getCurrentChild().isNeedDownload();
    }

    @Override
    public boolean isNeedExtraction() {
        return this.getCurrentChild().isNeedExtraction();
    }

    public Installable getCurrentChild() {
        return this.children[this.currentId];
    }

    @Override
    public Installable orig() {
        return this.getCurrentChild();
    }
}

