/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.TwrpInstall;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.RomException;
import com.xiaomitool.v2.rom.interfaces.InstallObject;
import com.xiaomitool.v2.tasks.DownloadTask;
import com.xiaomitool.v2.tasks.ExtractionTask;
import com.xiaomitool.v2.tasks.ExtractionTask$ExtractionType;
import com.xiaomitool.v2.tasks.TaskManager;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.NotNull;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javafx.scene.image.Image;
import org.apache.commons.io.FilenameUtils;

public class TwrpFile
extends Installable {
    private String codename;

    public TwrpFile(String string, String string2) {
        super(Installable$Type.IMAGE, false, string, true, true, string);
        this.codename = string2;
    }

    public TwrpFile(File file, String string) {
        super(Installable$Type.IMAGE, false, file.getAbsolutePath(), false, true, file);
        this.codename = string;
    }

    @Override
    protected File downloadInternal(UpdateListener updateListener) {
        Object object;
        DownloadTask downloadTask = new DownloadTask(updateListener, this.downloadUrl, (File)null);
        if (this.downloadUrl.contains("/dl.twrp.me/")) {
            object = new HashMap();
            ((HashMap)object).put("Referer", this.downloadUrl + ".html");
            downloadTask.setHeaders((Map<String, String>)object);
        }
        object = TaskManager.getInstance();
        ((TaskManager)object).startSameThread(downloadTask);
        if (!downloadTask.isFinished()) {
            throw new RomException("Failed to download file");
        }
        this.downloadedFile = (File)downloadTask.getResult();
        return this.downloadedFile;
    }

    @Override
    @NotNull
    protected File extractInternal(UpdateListener updateListener) {
        File file = this.getDownloadedFile();
        if (file == null) {
            throw new RomException("Missing downloaded file");
        }
        if (!file.getName().toLowerCase().endsWith(".zip")) {
            this.setFinalFile(file);
            return file;
        }
        ExtractionTask extractionTask = new ExtractionTask(updateListener, file, null, ExtractionTask$ExtractionType.ZIP, false);
        TaskManager taskManager = TaskManager.getInstance();
        taskManager.startSameThread(extractionTask);
        if (!extractionTask.isFinished()) {
            throw new RomException("Extraction task failed: " + (extractionTask.getError() == null ? "null error" : extractionTask.getError().getMessage()));
        }
        File file2 = (File)extractionTask.getResult();
        File[] fileArray = file2.listFiles(File::isFile);
        if (fileArray == null) {
            IOException iOException = new IOException("Cannot find twrp extraction directory children");
            updateListener.onError(iOException);
            throw iOException;
        }
        this.setFinalFile(null);
        for (File file3 : fileArray) {
            String string = file3.getName().toLowerCase();
            if (!string.endsWith(".img") || !string.contains("twrp") && !string.contains(this.codename)) continue;
            this.setFinalFile(file3);
            break;
        }
        if (this.finalFile == null) {
            IOException iOException = new IOException("Could not find a valid twrp image file in extracted directory");
            updateListener.onError(iOException);
            throw iOException;
        }
        return this.finalFile;
    }

    @Override
    public LinkedHashSet<Device$Status> getRequiredStates() {
        return InstallObject.SET_FASTBOOT;
    }

    @Override
    public RInstall getInstallProcedure() {
        return TwrpInstall.flashTwrp();
    }

    @Override
    public String getTitle() {
        return LRes.TWRP_RECOVERY.toString() + (this.getDownloadUrl() != null ? " - " + FilenameUtils.getName(this.getDownloadUrl()) : "");
    }

    @Override
    public String getText() {
        return this.getDownloadUrl() != null ? LRes.TWRP_AUTO_DOWNLOAD.toString() : LRes.TWRP_SELECT_MANUAL.toString();
    }

    @Override
    public Image getIcon() {
        return DrawableManager.getResourceImage("twrplogo.png");
    }
}

