/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom.chooser;

import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.DeviceGroups;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.rom.MiuiZipRom;
import com.xiaomitool.v2.rom.MultiInstallable;
import com.xiaomitool.v2.rom.chooser.InstallationRequirement$1;
import com.xiaomitool.v2.rom.chooser.InstallationRequirement$2;
import com.xiaomitool.v2.rom.chooser.InstallationRequirement$3;
import com.xiaomitool.v2.rom.chooser.InstallationRequirement$4;
import com.xiaomitool.v2.rom.chooser.InstallationRequirement$5;
import com.xiaomitool.v2.rom.interfaces.StatedProcedure;
import com.xiaomitool.v2.xiaomi.miuithings.UnlockStatus;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class InstallationRequirement
implements StatedProcedure {
    public static final InstallationRequirement USB_DEBUG_ENABLED = new InstallationRequirement$1("usb debug enabled", new InstallationRequirement[0]);
    public static final InstallationRequirement STOCKRECOVERY_REACHABLE = new InstallationRequirement$2("stock recovery reachable", USB_DEBUG_ENABLED);
    public static final InstallationRequirement CHECK_IF_TWRP_INSTALLED = new InstallationRequirement$3("check if twrp installed", USB_DEBUG_ENABLED);
    public static final InstallationRequirement UNLOCKED_BOOTLOADER = new InstallationRequirement$4("bootloader unlock", new InstallationRequirement[0]);
    public static final InstallationRequirement TWRP_INSTALLED = new InstallationRequirement$5("twrp install", UNLOCKED_BOOTLOADER, CHECK_IF_TWRP_INSTALLED);
    private InstallationRequirement[] subRequirements;
    private String id;

    private InstallationRequirement(String string, InstallationRequirement ... installationRequirementArray) {
        this.id = string;
        this.subRequirements = installationRequirementArray != null ? installationRequirementArray : new InstallationRequirement[]{};
    }

    public static LinkedList<InstallationRequirement> toSatisfyRequirements(Device device, InstallationRequirement ... installationRequirementArray) {
        LinkedList<InstallationRequirement> linkedList = new LinkedList<InstallationRequirement>();
        for (InstallationRequirement installationRequirement2 : installationRequirementArray) {
            InstallationRequirement.toSatisfyInternal(device, installationRequirement2, linkedList);
        }
        linkedList.sort(Comparator.comparingInt(installationRequirement -> installationRequirement.getSubRequirements().length));
        return linkedList;
    }

    private static void toSatisfyInternal(Device device, InstallationRequirement installationRequirement, LinkedList<InstallationRequirement> linkedList) {
        if (!installationRequirement.isSatisfied(device)) {
            if (!linkedList.contains(installationRequirement)) {
                linkedList.addFirst(installationRequirement);
            }
            for (InstallationRequirement installationRequirement2 : installationRequirement.getSubRequirements()) {
                InstallationRequirement.toSatisfyInternal(device, installationRequirement2, linkedList);
            }
        }
    }

    public static StatedProcedure satisfyNextRequirement(Device device, Installable installable) {
        InstallationRequirement[] installationRequirementArray = InstallationRequirement.getInstallableRequirements(installable, device);
        if (installationRequirementArray.length == 0) {
            return null;
        }
        LinkedList<InstallationRequirement> linkedList = InstallationRequirement.toSatisfyRequirements(device, installationRequirementArray);
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.get(0);
    }

    public static List<InstallationRequirement> getAllInstallableRequirements(Installable installable, Device device) {
        return InstallationRequirement.toSatisfyRequirements(device, InstallationRequirement.getInstallableRequirements(installable, device));
    }

    public static InstallationRequirement[] getInstallableRequirements(Installable installable, Device device) {
        LinkedList<InstallationRequirement> linkedList = new LinkedList<InstallationRequirement>();
        switch (installable.getType()) {
            case RECOVERY: {
                boolean bl = !UnlockStatus.UNLOCKED.equals((Object)device.getAnswers().getUnlockStatus()) || STOCKRECOVERY_REACHABLE.isSatisfied(device);
                boolean bl2 = (installable.hasInstallToken() || installable.isOfficial()) && installable instanceof MiuiZipRom;
                boolean bl3 = false;
                if (bl2) {
                    MiuiZipRom miuiZipRom = (MiuiZipRom)installable;
                    MiuiRom$Specie miuiRom$Specie = miuiZipRom.getSpecie();
                    MiuiRom$Specie miuiRom$Specie2 = device.getAnswers().getCurrentSpecie();
                    if (miuiRom$Specie2.getZone() != miuiRom$Specie.getZone()) {
                        String string = device.getDeviceProperties().getCodename(true);
                        boolean bl4 = bl3 = !DeviceGroups.isSafeToChangeRecoveryLocked(string);
                    }
                }
                if (!bl2) {
                    linkedList.add(TWRP_INSTALLED);
                    break;
                }
                if (bl3) {
                    linkedList.add(UNLOCKED_BOOTLOADER);
                }
                if (bl) break;
                linkedList.add(STOCKRECOVERY_REACHABLE);
                break;
            }
            case IMAGE: 
            case FASTBOOT: {
                linkedList.add(UNLOCKED_BOOTLOADER);
                break;
            }
            case MULTI: {
                return InstallationRequirement.getInstallableRequirements(((MultiInstallable)installable).getCurrentChild(), device);
            }
        }
        return linkedList.toArray(new InstallationRequirement[0]);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public InstallationRequirement[] getSubRequirements() {
        return this.subRequirements;
    }

    public abstract boolean isSatisfied(Device var1);

    public abstract String getHumanName(Device var1);

    /* synthetic */ InstallationRequirement(String string, InstallationRequirement[] installationRequirementArray, InstallationRequirement$1 installationRequirement$1) {
        this(string, installationRequirementArray);
    }
}

