/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.tasks.AdbPushTask$1;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.Pointer;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class AdbPushTask
extends Task {
    private AdbRunner runner;
    private String device;
    private String destinationPath;
    private File sourceFile;

    public AdbPushTask(UpdateListener updateListener, String string, String string2, String string3) {
        this(updateListener, new File(string), string2, string3);
    }

    public AdbPushTask(UpdateListener updateListener, File file, String string, String string2) {
        super(updateListener);
        this.sourceFile = file;
        this.destinationPath = string;
        this.device = string2;
    }

    @Override
    protected void startInternal() {
        this.runner = new AdbRunner();
        this.runner.setDeviceSerial(this.device);
        this.runner.addArgument("push");
        this.runner.addArgument(this.sourceFile.getAbsolutePath());
        long l = this.sourceFile.length();
        this.runner.addArgument(this.destinationPath);
        Pattern pattern = Pattern.compile("\\[(\\d+)/(\\d+)\\]");
        Pattern pattern2 = Pattern.compile("\\[\\s*(\\d+)%\\]");
        Pointer pointer = new Pointer();
        Pointer pointer2 = new Pointer();
        pointer2.pointed = false;
        this.runner.addSyncCallback(new AdbPushTask$1(this, pointer, pattern, l, pattern2));
        try {
            this.runner.runWait(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        if (this.runner.getExitValue() != 0) {
            String string;
            String string2 = string = pointer.pointed != null ? pointer.pointed.toString() : "exit code " + this.runner.getExitValue();
            if (string.toLowerCase().contains("no space left on device")) {
                string = LRes.NO_SPACE_LEFT_DEVICE.toString();
            }
            this.error(new AdbException("Failed to push file to the device: " + string));
            return;
        }
        this.finished(this.sourceFile);
    }

    @Override
    protected boolean canPause() {
        return false;
    }

    @Override
    protected boolean canStop() {
        return true;
    }

    @Override
    protected boolean pauseInternal() {
        return false;
    }

    @Override
    protected boolean stopInternal() {
        this.abort();
        if (this.runner != null) {
            return this.runner.kill();
        }
        return true;
    }
}

