/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.adb.AdbCommunication;
import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.tasks.AdbSideloadTask$1;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class AdbSideloadTask
extends Task {
    private static final Pattern PROGRESS_MATCH = Pattern.compile("\\[\\s*(\\d+)/\\s*(\\d+)\\]");
    private File fileToSideload;
    private String token;
    private String serial;

    public AdbSideloadTask(File file, String string, String string2) {
        this.fileToSideload = file;
        this.token = string;
        this.serial = string2;
    }

    @Override
    protected void startInternal() {
        long l;
        AdbRunner adbRunner = new AdbRunner();
        adbRunner.setDeviceSerial(this.serial);
        adbRunner.addArgument("sideload");
        if (this.fileToSideload == null) {
            this.error(new InstallException("null file to sideload", InstallException$Code.INTERNAL_ERROR));
        }
        adbRunner.addArgument(this.fileToSideload.getAbsolutePath());
        if (!StrUtils.isNullOrEmpty(this.token)) {
            adbRunner.addArgument(this.token);
        }
        adbRunner.addSyncCallback(new AdbSideloadTask$1(this));
        AdbCommunication.getAllAccess();
        try {
            adbRunner.runWait();
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        finally {
            AdbCommunication.giveAllAccess();
        }
        if (adbRunner.getExitValue() != 0) {
            this.error(new InstallException(new AdbException("adb sideload exited with status: " + adbRunner.getExitValue())));
            return;
        }
        String string = adbRunner.getOutputString();
        if (string == null) {
            this.error(new AdbException("output of sideload is null"));
            return;
        }
        if ((string = string.toLowerCase()).contains("complete")) {
            this.finished(this.fileToSideload);
            return;
        }
        if (string.contains("abort")) {
            this.error(new AdbException("output of sideload is abort, progress: " + this.getLatestUpdate() + "/" + this.getTotalSize()));
            return;
        }
        if (this.getLatestUpdate() >= 0L && this.getTotalSize() > 0L && (l = this.getLatestUpdate() / this.getTotalSize()) < 90L) {
            this.error(new AdbException("sideload completed only for " + l + "%, the installation might not completed succesfully"));
            return;
        }
        this.finished(this.fileToSideload);
    }

    @Override
    protected boolean canPause() {
        return false;
    }

    @Override
    protected boolean canStop() {
        return false;
    }

    @Override
    protected boolean pauseInternal() {
        return false;
    }

    @Override
    protected boolean stopInternal() {
        return false;
    }

    static /* synthetic */ Pattern access$000() {
        return PROGRESS_MATCH;
    }
}

