/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.tasks.Task$STATUS;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.tasks.UpdateListener$Debug;
import com.xiaomitool.v2.utility.WaitSemaphore;
import java.time.Duration;
import java.time.LocalDateTime;

public abstract class Task {
    protected Task$STATUS status = Task$STATUS.READY;
    protected UpdateListener listener;
    protected Thread runningThread;
    private Object result;
    private Exception error;
    private long totalSize = -1L;
    private LocalDateTime timeLatestUpdate;
    private LocalDateTime timeStart;
    private WaitSemaphore isNotRunning = new WaitSemaphore();
    private long latestUpdate = -1L;
    private int nextLogStep = 0;

    public Task() {
        this.listener = new UpdateListener$Debug();
    }

    public Task(UpdateListener updateListener) {
        this.listener = updateListener;
    }

    public UpdateListener getListener() {
        return this.listener;
    }

    public void setListener(UpdateListener updateListener) {
        this.listener = updateListener;
    }

    void restart() {
        Log.info("Restarting task: " + this);
        if (this.runningThread != null) {
            this.runningThread.join(2000L);
            this.start(false);
        } else {
            this.start(true);
        }
    }

    void start() {
        this.start(false);
    }

    private void start(boolean bl) {
        this.status = Task$STATUS.RUNNING;
        this.timeStart = LocalDateTime.now();
        this.timeLatestUpdate = LocalDateTime.now();
        Log.info("Starting task: same thread: " + bl + " : " + this);
        Runnable runnable = () -> {
            try {
                this.startInternal();
            }
            catch (Exception exception) {
                this.error(exception);
            }
        };
        if (bl) {
            runnable.run();
        } else {
            this.runningThread = new Thread(runnable);
            this.runningThread.start();
        }
    }

    protected void update(long l) {
        long l2;
        if ((l >= 0L || this.totalSize > 0L) && (l2 = l / this.totalSize) >= (long)this.nextLogStep) {
            Log.info("Task completed at " + l2 + "%");
            this.nextLogStep += 10;
        }
        this.latestUpdate = l;
        Duration duration = Duration.between(this.timeLatestUpdate, LocalDateTime.now());
        this.timeLatestUpdate = (LocalDateTime)duration.addTo(this.timeLatestUpdate);
        Duration duration2 = Duration.between(this.timeStart, this.timeLatestUpdate);
        this.listener.onUpdate(l, this.totalSize, duration, duration2);
    }

    public long getLatestUpdate() {
        return this.latestUpdate;
    }

    protected void finished(Object object) {
        Log.info("Task finished: result: " + object + " : " + this);
        this.update(this.totalSize);
        this.result = object;
        this.status = Task$STATUS.FINISHED;
        this.listener.onFinished(object);
        this.isNotRunning.increase();
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    protected void error(Exception exception) {
        Log.error("Task error: exception: " + exception.getMessage() + " : " + this);
        this.status = Task$STATUS.ERROR;
        this.error = exception;
        this.listener.onError(exception);
        this.isNotRunning.increase();
    }

    protected abstract void startInternal();

    public long getTotalSize() {
        return this.totalSize;
    }

    protected void setTotalSize(long l) {
        this.totalSize = l;
        this.listener.onStart(this.totalSize);
    }

    public boolean pause() {
        if (!this.canPause()) {
            return false;
        }
        if (this.pauseInternal()) {
            Log.info("Task paused: " + this);
            this.status = Task$STATUS.PAUSED;
            return true;
        }
        return false;
    }

    public boolean stop() {
        if (!this.canStop()) {
            return false;
        }
        if (this.stopInternal()) {
            Log.info("Task aborted: " + this);
            this.status = Task$STATUS.ABORTED;
            return true;
        }
        return false;
    }

    protected void abort() {
        this.status = Task$STATUS.ABORTED;
        this.isNotRunning.increase();
    }

    public Task$STATUS waitFinished() {
        this.isNotRunning.waitOnce();
        return this.status;
    }

    public Object getResult() {
        return this.result;
    }

    public Exception getError() {
        return this.error;
    }

    public String getStatusString() {
        return this.status.toString();
    }

    public boolean isFinished() {
        return Task$STATUS.FINISHED.equals((Object)this.status);
    }

    protected abstract boolean canPause();

    protected abstract boolean canStop();

    protected abstract boolean pauseInternal();

    protected abstract boolean stopInternal();

    void startSameThread() {
        this.start(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " -> status: " + (Object)((Object)this.status);
    }
}

