/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.RunnableWithArg;

public class TwrpInstallTask
extends Task {
    private static final String[] TWRP_ERROR = new String[]{"Error installing zip file", "Errore durante l'installazione dello Zip", "\u00e5\u00ae\u2030\u00e8\u00a3\u009dzip\u00e5\u02c6\u00b7\u00e6\u00a9\u0178\u00e5\u0152\u2026|\u00e5\u2021\u00ba\u00e9\u0152\u00af", "\u00e6\u0153\u00ba\u00e5\u0152\u2026\u00e6\u2013\u2021\u00e4\u00bb\u00b6"};
    protected AdbRunner adbRunner;
    private RunnableWithArg outputRunable;

    public TwrpInstallTask(UpdateListener updateListener, String string, String string2, RunnableWithArg runnableWithArg) {
        super(updateListener);
        this.adbRunner = new AdbRunner("shell", "-x", "twrp install " + string2);
        this.adbRunner.setDeviceSerial(string);
        this.outputRunable = runnableWithArg;
    }

    @Override
    protected void startInternal() {
        if (this.outputRunable != null) {
            this.adbRunner.addSyncCallback(this.outputRunable);
        }
        this.adbRunner.runWait(3600);
        if (this.adbRunner.getExitValue() != 0) {
            throw new AdbException("Return code of adb install is not zero");
        }
        String string = this.adbRunner.getOutputString();
        if (string == null) {
            throw new AdbException("Failed to get output of twrp install");
        }
        string = string.toLowerCase();
        for (String string2 : TWRP_ERROR) {
            if (!string.contains(string2.toLowerCase())) continue;
            throw new AdbException("Failed to install zip: " + string2);
        }
        this.finished(this.adbRunner.getOutputString());
    }

    @Override
    protected boolean canPause() {
        return false;
    }

    @Override
    protected boolean canStop() {
        return true;
    }

    @Override
    protected boolean pauseInternal() {
        return false;
    }

    @Override
    protected boolean stopInternal() {
        return this.adbRunner.kill();
    }
}

