/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.ProcessRunner;
import com.xiaomitool.v2.resources.ResourcesManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DriverUtils {
    private static final String SUCCESS = "result_success";
    private static final String FAIL = "result_fail";
    private static ProcessRunner FIX_ANDROID_SERVICE = null;

    private static ProcessRunner getDriverRunner() {
        return new ProcessRunner(ResourcesManager.getToolPath("driver", true));
    }

    public static boolean installDriver(String string) {
        return DriverUtils.installDriver(Paths.get(string, new String[0]));
    }

    public static boolean installDriver(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Log.error("Failed to install driver: path not found");
            return false;
        }
        return DriverUtils.runCommand("install", 60, "install", path.toString());
    }

    private static boolean runCommand(String string, int n, String ... stringArray) {
        ProcessRunner processRunner = DriverUtils.getDriverRunner();
        for (String string2 : stringArray) {
            processRunner.addArgument(string2);
        }
        try {
            processRunner.runWait(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n2 = processRunner.getExitValue();
        if (n2 != 0) {
            Log.error("Driver tool " + string + " returned with code: " + n2);
            Log.info(processRunner.getOutputString());
            return false;
        }
        String string3 = processRunner.getOutputString();
        if (string3.contains(SUCCESS)) {
            return true;
        }
        if (string3.contains(FAIL)) {
            Log.error("Driver " + string + " failed. Tool fail message match");
            Log.info(string3);
            return false;
        }
        Log.warn("Unknown driver " + string + " outcome");
        Log.info(string3);
        return true;
    }

    public static boolean refresh() {
        return DriverUtils.runCommand("refresh", 10, "refresh");
    }

    public static boolean fixAndroidDevices(Path path) {
        return DriverUtils.runCommand("fixandroid", 10, "fixandroid", path.toString());
    }

    public static synchronized void requireFixAndroidService(Path path) {
        if (FIX_ANDROID_SERVICE == null || !FIX_ANDROID_SERVICE.isAlive()) {
            FIX_ANDROID_SERVICE = DriverUtils.getDriverRunner();
            FIX_ANDROID_SERVICE.addArgument("fixandroid-service");
            FIX_ANDROID_SERVICE.addArgument(path.toString());
            FIX_ANDROID_SERVICE.start();
        }
    }

    public static void stopFixAndroidService() {
        if (FIX_ANDROID_SERVICE == null || !FIX_ANDROID_SERVICE.isAlive()) {
            return;
        }
        FIX_ANDROID_SERVICE.kill();
        FIX_ANDROID_SERVICE = null;
    }

    public static boolean fixMtpDevices() {
        DriverUtils.refresh();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return DriverUtils.runCommand("fixmtp", 60, "fixmtp");
    }
}

