/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility;

import com.xiaomitool.v2.process.ProcessRunner;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.utility.MTPUtils$1;
import com.xiaomitool.v2.utility.MTPUtils$MTPDevice;
import com.xiaomitool.v2.utility.OSNotSupportedException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

public class MTPUtils {
    private static String WIN_MTP_EXE = "mtp";

    private static ProcessRunner winMtpRunner() {
        return new ProcessRunner(ResourcesManager.getToolPath(WIN_MTP_EXE, true));
    }

    public static HashMap<String, MTPUtils$MTPDevice> list() {
        HashMap<String, MTPUtils$MTPDevice> hashMap = new HashMap<String, MTPUtils$MTPDevice>();
        OSNotSupportedException.requireWindows();
        ProcessRunner processRunner = MTPUtils.winMtpRunner();
        processRunner.addArgument("list");
        processRunner.runWait();
        if (processRunner.getExitValue() != 0) {
            return hashMap;
        }
        List<String> list = processRunner.getOutputLines();
        list = MTPUtils.stripOutput(list);
        for (String string : list) {
            try {
                String string2 = new String(Base64.getDecoder().decode(string));
                hashMap.put(string2, new MTPUtils$MTPDevice(string2));
            }
            catch (Throwable throwable) {}
        }
        return hashMap;
    }

    public static String getRoot(MTPUtils$MTPDevice mTPUtils$MTPDevice) {
        OSNotSupportedException.requireWindows();
        ProcessRunner processRunner = MTPUtils.winMtpRunner();
        processRunner.addArgument("getroot");
        processRunner.addArgument(Base64.getEncoder().encodeToString(mTPUtils$MTPDevice.id.getBytes(ResourcesConst.interalCharset())));
        processRunner.runWait();
        if (processRunner.getExitValue() != 0) {
            return "";
        }
        return processRunner.getOutputLines().get(0);
    }

    public static Task getPushTask(MTPUtils$MTPDevice mTPUtils$MTPDevice, Path path, String string) {
        OSNotSupportedException.requireWindows();
        ProcessRunner processRunner = MTPUtils.winMtpRunner();
        processRunner.addArgument("push");
        processRunner.addArgument(Base64.getEncoder().encodeToString(mTPUtils$MTPDevice.id.getBytes(ResourcesConst.interalCharset())));
        processRunner.addArgument(path.toString());
        processRunner.addArgument(string);
        return new MTPUtils$1(path, processRunner);
    }

    private static List<String> stripOutput(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.startsWith("*")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

