/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MultipleInputStream
extends InputStream {
    private final List<InputStream> streams = new LinkedList<InputStream>();
    private InputStream currentInputStream;
    private int currentIndex = -1;

    public MultipleInputStream(Collection<InputStream> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("At least one stream is required");
        }
        this.streams.addAll(collection);
        this.incrementCurrent();
    }

    public MultipleInputStream(InputStream ... inputStreamArray) {
        if (inputStreamArray.length == 0) {
            throw new IllegalArgumentException("At least one stream is required");
        }
        this.streams.addAll(Arrays.asList(inputStreamArray));
        this.incrementCurrent();
    }

    @Override
    public int read() {
        int n = this.currentInputStream.read();
        if (n < 0 && this.incrementCurrent()) {
            return this.read();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        int n = this.currentInputStream.read(byArray);
        if (n <= 0 && this.incrementCurrent()) {
            return this.read(byArray);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.currentInputStream.read(byArray, n, n2);
        if (n3 <= 0 && this.incrementCurrent()) {
            return this.read(byArray, n, n2);
        }
        return n3;
    }

    private boolean incrementCurrent() {
        if (++this.currentIndex >= this.streams.size()) {
            return false;
        }
        this.currentInputStream = this.streams.get(this.currentIndex);
        return true;
    }
}

