/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.apk.ApkManifestDecoder;
import com.xiaomitool.v2.apk.ApkManifestParser;
import com.xiaomitool.v2.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;

public class ApkUtils {
    public static String getPackageName(Path path) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Closeable closeable = new ApkManifestDecoder(path);
            Object object = null;
            try {
                closeable.open();
                closeable.decode(byteArrayOutputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        closeable.close();
                    }
                }
            }
            byteArrayOutputStream.close();
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object = new ApkManifestParser();
            ((ApkManifestParser)object).open((InputStream)closeable);
            return ((ApkManifestParser)object).getPackageName();
        }
        catch (Throwable throwable) {
            Log.warn("Failed to get apk package name for " + path + ": " + throwable.getMessage());
            return null;
        }
    }
}

