/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final int FILE_READ_BUFFER_SIZE = 524288;

    public static long getFreeSpace(File file) {
        return file.getUsableSpace();
    }

    public static String readAll(File file) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 524288);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream, 524288);
        byteArrayOutputStream.close();
        bufferedInputStream.close();
        return byteArrayOutputStream.toString();
    }

    public static void writeAll(File file, String string) {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 524288);
        bufferedOutputStream.write(string.getBytes(ResourcesConst.interalCharset()));
        bufferedOutputStream.close();
    }

    public static File selectFile(String string, FileChooser.ExtensionFilter ... extensionFilterArray) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(ResourcesManager.getTmpPath().toFile());
        fileChooser.setTitle(string);
        if (extensionFilterArray != null) {
            fileChooser.getExtensionFilters().addAll((Object[])extensionFilterArray);
        }
        return fileChooser.showOpenDialog((Window)WindowManager.mainWindow());
    }

    public static Path searchFile(Path path2, String string, boolean bl, int n) {
        if (string == null) {
            return null;
        }
        try (Stream<Path> stream = Files.walk(path2, n, new FileVisitOption[0]);){
            Path path3 = stream.filter(path -> {
                String string2 = path.getFileName().toString().toLowerCase();
                return bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
            }).findFirst().orElse(null);
            return path3;
        }
    }

    public static Path toCanonical(Path path) {
        try {
            return path.normalize().toFile().getCanonicalFile().toPath();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static FileSystem openZipFileSystem(Path path, boolean bl) {
        Path path2 = path;
        URI uRI = URI.create("jar:file:" + path2.toUri().getPath());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bl) {
            hashMap.put("create", "true");
        }
        return FileSystems.newFileSystem(uRI, hashMap);
    }
}

