/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.crypto.AES;
import com.xiaomitool.v2.crypto.Hash;
import com.xiaomitool.v2.gui.controller.MainWindowController;
import com.xiaomitool.v2.language.Lang;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.NotNull;
import com.xiaomitool.v2.utility.utils.FileUtils;
import com.xiaomitool.v2.utility.utils.SettingsUtils$Region;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.xiaomi.b;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class SettingsUtils
extends HashMap<String, String> {
    public static final String PREF_DOWNLOAD_DIR = "pref_download_dir";
    public static final String PREF_EXTRACT_DIR = "pref_extract_dir";
    public static final String PREF_SAVE_SESSION = "pref_save_session";
    public static final String SESSION_TOKEN = "session_token";
    public static final String PC_ID = "pcId";
    public static final String REGION = "region";
    public static final String LANGUAGE = "language";
    public static final String lineSeparator = System.lineSeparator();
    public static final String fileSeparator = File.separator;
    private static final Path settingsPath = ResourcesManager.getTmpPath().resolve("settings.app");
    private static final SettingsUtils instance = new SettingsUtils();
    private static boolean loaded = false;
    private static boolean toSave = false;
    private static SettingsUtils$Region selectedRegion = null;

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        if (Files.exists(settingsPath, new LinkOption[0]) && Files.isRegularFile(settingsPath, new LinkOption[0])) {
            try {
                SettingsUtils.loadFileSettings(settingsPath);
            }
            catch (IOException iOException) {
                Log.error("Failed to load settings file: " + iOException.getMessage());
            }
        }
    }

    private static void loadFileSettings(@NotNull Path path) {
        String string = FileUtils.readAll(path.toFile());
        String[] stringArray = string.split("\\n");
        Pattern pattern = Pattern.compile("^([^=]+)=(.*)$");
        for (String string2 : stringArray) {
            String string3;
            Matcher matcher = pattern.matcher(string2 = string2.trim());
            if (!matcher.matches() || "null".equals(string3 = matcher.group(2))) continue;
            instance.put(matcher.group(1), string3);
        }
    }

    public static Path getDownloadPath() {
        String string = (String)instance.get(PREF_DOWNLOAD_DIR);
        if (string != null) {
            return Paths.get(string, new String[0]);
        }
        return ResourcesManager.getTmpPath();
    }

    public static void saveOpt(String string, String string2) {
        toSave = true;
        instance.put(string, string2);
    }

    public static Path getExtractPath() {
        String string = (String)instance.get(PREF_EXTRACT_DIR);
        if (string != null) {
            return Paths.get(string, new String[0]);
        }
        return ResourcesManager.getTmpPath();
    }

    public static SettingsUtils getInstance() {
        return instance;
    }

    public static String getOpt(String string) {
        return (String)instance.get(string);
    }

    public static File getDownloadFile(String string) {
        SettingsUtils.load();
        String string2 = FilenameUtils.getName(string);
        return SettingsUtils.getDownloadPath().resolve(string2).toFile();
    }

    public static File getExtractFile(File file, int n) {
        SettingsUtils.load();
        String string = FilenameUtils.getBaseName(file.getAbsolutePath());
        return SettingsUtils.getExtractPath().resolve(string + (n == 0 ? "" : "_" + n)).toFile();
    }

    public static void unset(String string) {
        instance.remove(string);
    }

    public static void save() {
        if (!toSave) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : instance.entrySet()) {
            if (((String)entry.getKey()).startsWith("_")) continue;
            stringBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\n');
        }
        String string = stringBuilder.toString().trim();
        try {
            FileUtils.writeAll(settingsPath.toFile(), string);
        }
        catch (IOException iOException) {
            Log.error("Failed to save settings file: " + iOException.getMessage());
        }
    }

    public static void saveOptEncrpyted(String string, String string2) {
        String string3;
        String string4 = StrUtils.randomWord(16);
        String string5 = Hash.md5Hex(string4);
        String string6 = string5.substring(0, 16);
        String string7 = string5.substring(16, 32);
        try {
            string3 = Base64.getEncoder().encodeToString(AES.aes128cbc_encrypt(string6.getBytes(StandardCharsets.ISO_8859_1), string7.getBytes(StandardCharsets.ISO_8859_1), string2.getBytes(ResourcesConst.interalCharset())));
        }
        catch (Exception exception) {
            Log.error("Failed to save encrypted data: " + exception.getMessage());
            return;
        }
        SettingsUtils.saveOpt(string, string3);
        SettingsUtils.saveOpt(string + ".key", string4);
    }

    public static String getOptDecrypted(String string) {
        String string2;
        String string3 = SettingsUtils.getOpt(string + ".key");
        if (string3 == null) {
            return null;
        }
        String string4 = Hash.md5Hex(string3);
        String string5 = string4.substring(0, 16);
        String string6 = string4.substring(16, 32);
        String string7 = SettingsUtils.getOpt(string);
        if (string7 == null) {
            return null;
        }
        try {
            string2 = new String(AES.aes128cbc_decrypt(string5.getBytes(StandardCharsets.ISO_8859_1), string6.getBytes(StandardCharsets.ISO_8859_1), Base64.getDecoder().decode(string7)));
        }
        catch (Exception exception) {
            Log.error("Failed to get encrypted data: " + exception.getMessage());
            return null;
        }
        return string2;
    }

    public static SettingsUtils$Region getRegion() {
        String string;
        if (selectedRegion == null && (string = (String)instance.get(REGION)) != null) {
            SettingsUtils$Region settingsUtils$Region;
            selectedRegion = settingsUtils$Region = SettingsUtils$Region.fromString(string);
        }
        return selectedRegion;
    }

    public static String getLanguage() {
        return (String)instance.get(LANGUAGE);
    }

    public static void setLanguage(String string) {
        instance.put(LANGUAGE, string);
        Lang.load();
        MainWindowController mainWindowController = MainWindowController.getInstance();
        if (mainWindowController != null) {
            mainWindowController.retext();
        }
    }

    public static void setRegion(SettingsUtils$Region settingsUtils$Region) {
        selectedRegion = settingsUtils$Region;
        instance.put(REGION, settingsUtils$Region.toString());
    }

    public static String requirePCId() {
        String string = (String)instance.get(PC_ID);
        if ((StrUtils.isNullOrEmpty(string) || "null".equals(string)) && StrUtils.isNullOrEmpty(string = b.c().h())) {
            b.c().a(b.b());
            string = b.c().h();
        }
        return string;
    }

    public static String requireHashedPCId() {
        return Hash.sha1Hex(SettingsUtils.requirePCId()).substring(20);
    }

    public static boolean isGlobalRegion() {
        return !SettingsUtils$Region.CN.equals((Object)SettingsUtils.getRegion());
    }
}

