/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.resources.ResourcesConst;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONException;
import org.json.JSONObject;

public class StrUtils {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.00");
    static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Pattern PROGRESS_REGEX = Pattern.compile("\\[\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*\\]");
    private static final byte[] SPACE_STRING = "                                                ".getBytes(ResourcesConst.interalCharset());
    private static final byte[] TABS_STIRNG = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".getBytes(ResourcesConst.interalCharset());

    public static String randomWord(int n) {
        int n2 = CHARS.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(CHARS.charAt(ThreadLocalRandom.current().nextInt(0, n2)));
        }
        return stringBuilder.toString();
    }

    public static long[] parseProgress(String string) {
        try {
            Matcher matcher = PROGRESS_REGEX.matcher(string);
            if (matcher.find()) {
                long[] lArray = new long[]{Long.parseLong(matcher.group(1), 10), Long.parseLong(matcher.group(2), 10)};
                return lArray;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String bytesToString(Number number) {
        String[] stringArray = new String[]{" ", "k", "M", "G", "T"};
        double d2 = number.doubleValue();
        int n = 0;
        while (d2 > 1000.0) {
            ++n;
            if (!Double.isInfinite(d2 /= 1000.0)) continue;
        }
        if (n >= stringArray.length) {
            return "Infinite";
        }
        return DECIMAL_FORMAT.format(d2) + " " + stringArray[n] + "B";
    }

    public static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String exceptionToOriginString(Throwable throwable) {
        return String.valueOf(throwable.getStackTrace()[0]);
    }

    public static String firstNLines(String string, int n) {
        String[] stringArray = string.split("\\n");
        return StrUtils.firstNLines(stringArray, n);
    }

    public static String firstNLines(String[] stringArray, int n) {
        int n2 = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n && i < n2; ++i) {
            stringBuilder.append('\n').append(stringArray[i]);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString().substring(1) : stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String str(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public static int lenght(String string) {
        return string == null ? -1 : string.length();
    }

    public static String map2json(Map<?, ?> map, int n) {
        return StrUtils.map2json(map, n, n);
    }

    private static String map2json(Map<?, ?> map, int n, int n2) {
        String string;
        if (!(map instanceof LinkedHashMap)) {
            return new JSONObject(map).toString(n);
        }
        String string2 = n > 0 ? "\n" : "";
        String string3 = string = StrUtils.indentToString(n);
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string4;
            if (entry.getValue() instanceof Number) {
                string4 = String.valueOf(entry.getValue());
            } else if (entry.getValue() instanceof String) {
                string4 = '\"' + entry.getValue().toString().replace("\"", "\\\"") + '\"';
            } else if (entry.getValue() instanceof Map) {
                string4 = StrUtils.map2json((Map)entry.getValue(), n + n2, n2);
            } else {
                throw new JSONException("Unknown type: " + entry.getValue().getClass().getSimpleName());
            }
            stringBuilder.append(string2).append(string3).append('\"').append(entry.getKey().toString()).append("\" : ").append(string4).append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1) + string2 + StrUtils.indentToString(n - n2) + "}" + (n == n2 ? string2 : "");
    }

    private static String indentToString(int n) {
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    public static int compareVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        for (int i = 0; i < Integer.min(stringArray.length, stringArray2.length); ++i) {
            int n;
            int n2 = Integer.parseInt(stringArray[i]);
            if (n2 < (n = Integer.parseInt(stringArray2[i]))) {
                return -1;
            }
            if (n2 <= n) continue;
            return 1;
        }
        return stringArray.length - stringArray2.length;
    }

    private static String chars(byte[] byArray, int n) {
        if (n < 0) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        while (n > 0) {
            int n2 = Integer.min(n, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n2);
            n -= n2;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static String tabs(int n) {
        return StrUtils.chars(TABS_STIRNG, n);
    }

    public static String spaces(int n) {
        return StrUtils.chars(SPACE_STRING, n);
    }

    public static String after(String string, String string2) {
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        for (n = 0; n < cArray.length && n < cArray2.length; ++n) {
            if (cArray[n] == cArray2[n]) continue;
            return null;
        }
        return new String(cArray, n, cArray.length - n);
    }

    public static String toHexString(byte[] byArray) {
        return Hex.encodeHexString(byArray);
    }

    public static String reverse(String string) {
        return new StringBuilder(string).reverse().toString();
    }

    public static String lastLine(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.split("\n")[0];
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

