/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.inet.EasyHttp;
import com.xiaomitool.v2.process.ProcessRunner;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.utils.MutexUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.utility.utils.UpdateUtils$1;
import com.xiaomitool.v2.utility.utils.UpdateUtils$UpdateStatus;
import com.xiaomitool.v2.xiaomi.b.a;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONObject;

public class UpdateUtils {
    private static final String BLOCK_VERSION = "0.0.0";
    private static final String ALIVE_YEAH = "what_a_nice_time_to_be_alive";
    private static boolean OPTIONS_OVERRODE = false;

    public static UpdateUtils$UpdateStatus checkForUpdatesV2(String string, String string2, String string3) {
        JSONObject jSONObject = new JSONObject(EasyHttp.get(string + "?i=" + string3 + "&v=" + string2 + "&p=" + ResourcesConst.getOSName()).getBody());
        String string4 = jSONObject.getString("lv");
        String string5 = jSONObject.getString("lf");
        String string6 = jSONObject.getString("lu");
        String string7 = jSONObject.getString("ls");
        UpdateUtils$UpdateStatus updateUtils$UpdateStatus = StrUtils.compareVersion(string4, BLOCK_VERSION) == 0 ? UpdateUtils$UpdateStatus.BLOCK : (StrUtils.compareVersion(string4, string2) <= 0 ? UpdateUtils$UpdateStatus.UPDATED : (StrUtils.compareVersion(string5, string2) > 0 ? UpdateUtils$UpdateStatus.FULL_UPDATE : UpdateUtils$UpdateStatus.QUICK_UPDATE));
        UpdateUtils$UpdateStatus.access$002(updateUtils$UpdateStatus, string5);
        UpdateUtils$UpdateStatus.access$102(updateUtils$UpdateStatus, string4);
        UpdateUtils$UpdateStatus.access$202(updateUtils$UpdateStatus, string6);
        UpdateUtils$UpdateStatus.access$302(updateUtils$UpdateStatus, string7);
        return updateUtils$UpdateStatus;
    }

    public static boolean checkIfAlive(Path path, Path path2) {
        ProcessRunner processRunner = new ProcessRunner(path);
        processRunner.addArgument("-jar");
        processRunner.addArgument(path2.toString());
        processRunner.addArgument("--isalive");
        processRunner.runWait(10);
        String string = processRunner.getOutputString();
        return string != null && string.contains(ALIVE_YEAH);
    }

    public static boolean startUpdateProcess(Path path, Path path2, boolean bl) {
        ProcessRunner processRunner = new ProcessRunner(path);
        processRunner.addArgument("-jar");
        processRunner.addArgument(path2.toString());
        if (bl) {
            processRunner.addArgument("--update_start");
        }
        return processRunner.start() != null;
    }

    public static boolean checkUpdateKillMe(String[] stringArray) {
        for (String string : stringArray) {
            if ("--isalive".equals(string)) {
                UpdateUtils.printAlive();
                return true;
            }
            if (!"--update_start".equals(string)) continue;
            return UpdateUtils.doUpdate();
        }
        UpdateUtils.removePendingUpdates();
        return false;
    }

    private static void removePendingUpdates() {
        new Thread(new UpdateUtils$1()).start();
    }

    private static boolean doUpdate() {
        Path path = ResourcesManager.getCurrentJarDirPath();
        Path path2 = ResourcesManager.getCurrentJarPath();
        Path path3 = path.resolve("XiaoMiTool.jar");
        if (!MutexUtils.waitUnlock(10)) {
            // empty if block
        }
        Files.copy(path2, path3, StandardCopyOption.REPLACE_EXISTING);
        if (!Files.exists(path3, new LinkOption[0])) {
            return false;
        }
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        hashSet.add(PosixFilePermission.OWNER_READ);
        hashSet.add(PosixFilePermission.OWNER_WRITE);
        hashSet.add(PosixFilePermission.OWNER_EXECUTE);
        hashSet.add(PosixFilePermission.OTHERS_READ);
        hashSet.add(PosixFilePermission.OTHERS_WRITE);
        hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
        hashSet.add(PosixFilePermission.GROUP_READ);
        hashSet.add(PosixFilePermission.GROUP_WRITE);
        hashSet.add(PosixFilePermission.GROUP_EXECUTE);
        try {
            Files.setPosixFilePermissions(path3, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path path4 = ResourcesManager.getJavaLaunchExe();
        if (path4 == null) {
            return false;
        }
        return UpdateUtils.startUpdateProcess(path4, path3, false);
    }

    private static void printAlive() {
        System.out.println(ALIVE_YEAH);
        System.out.flush();
    }

    public static void overrideUnlockOptions(String string) {
        if (OPTIONS_OVERRODE) {
            return;
        }
        String string2 = string + "/override_unlock.php";
        String string3 = EasyHttp.get(string2).getBody();
        JSONObject jSONObject = new JSONObject(string3);
        a.a(jSONObject.optString("client", null));
        JSONObject jSONObject2 = jSONObject.optJSONObject("unlock");
        if (jSONObject2 != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string4 : jSONObject2.keySet()) {
                hashMap.put(string4, jSONObject.get(string4));
            }
            a.a(hashMap);
        }
        OPTIONS_OVERRODE = true;
    }
}

