/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.xiaomi.miuithings;

import com.xiaomitool.v2.utility.KeepOriginClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Codebase
extends KeepOriginClass {
    public static final Codebase A4_4 = new Codebase("4.4");
    public static final Codebase A5_0 = new Codebase("5.0");
    public static final Codebase A5_1 = new Codebase("5.1");
    public static final Codebase A6_0 = new Codebase("6.0");
    public static final Codebase A7_0 = new Codebase("7.0");
    public static final Codebase A7_1 = new Codebase("7.1");
    public static final Codebase A8_0 = new Codebase("8.0");
    public static final Codebase A8_1 = new Codebase("8.1");
    public static final Codebase A9_0 = new Codebase("9.0");
    public static final Codebase A10_0 = new Codebase("10.0");
    public static final HashMap<Integer, Codebase> KNOWN_CODEBASE = new HashMap(10);
    public boolean isValid = true;
    private Integer main;
    private Integer sub;
    private Integer revision;

    public Codebase(String string) {
        super(string);
        if (string == null) {
            return;
        }
        Pattern pattern = Pattern.compile("(\\d)\\.(\\d)\\.{0,1}(\\d{0,1})");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            this.isValid = false;
            return;
        }
        this.main = Integer.parseInt(matcher.group(1));
        this.sub = Integer.parseInt(matcher.group(2));
        String string2 = matcher.group(3);
        this.revision = !string2.equals("") ? Integer.valueOf(Integer.parseInt(matcher.group(3))) : null;
    }

    public int getMain() {
        return this.main;
    }

    public int getSub() {
        return this.sub;
    }

    public Codebase next() {
        if (!this.isValid) {
            return null;
        }
        int n = this.main * 10 + this.sub;
        Codebase codebase = KNOWN_CODEBASE.get(n + 1);
        if (codebase == null) {
            n -= n % 10;
            codebase = KNOWN_CODEBASE.get(n + 10);
        }
        return codebase;
    }

    public List<Codebase> nexts(int n) {
        Codebase codebase;
        ArrayList<Codebase> arrayList = new ArrayList<Codebase>(n);
        arrayList.add(this);
        while (arrayList.size() < n && (codebase = this.next()) != null) {
            arrayList.add(codebase);
        }
        return arrayList;
    }

    int compare(Codebase codebase) {
        if (!this.isValid || !codebase.isValid) {
            return -2;
        }
        return this.main > codebase.getMain() ? 1 : (this.main < codebase.getMain() ? -1 : (this.sub > codebase.getSub() ? 1 : (this.sub < codebase.getSub() ? -1 : 0)));
    }

    @Override
    public String toString() {
        if (!this.isValid) {
            return super.toString();
        }
        return this.main + "." + this.sub + (this.revision != null ? "." + this.revision : "");
    }

    static {
        KNOWN_CODEBASE.put(40, A4_4);
        KNOWN_CODEBASE.put(50, A5_0);
        KNOWN_CODEBASE.put(51, A5_1);
        KNOWN_CODEBASE.put(60, A6_0);
        KNOWN_CODEBASE.put(70, A7_0);
        KNOWN_CODEBASE.put(71, A7_1);
        KNOWN_CODEBASE.put(80, A8_0);
        KNOWN_CODEBASE.put(81, A8_1);
        KNOWN_CODEBASE.put(90, A9_0);
        KNOWN_CODEBASE.put(100, A10_0);
    }
}

