/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.xiaomi.miuithings;

import com.xiaomitool.v2.utility.KeepOriginClass;
import com.xiaomitool.v2.xiaomi.miuithings.Branch;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion$CompareStatus;
import java.util.ArrayList;
import java.util.List;

public class MiuiVersion
extends KeepOriginClass {
    private Branch branch;
    private List<Integer> numbers;
    private int bigversion;
    private String charCode;
    private boolean isValid = true;

    public MiuiVersion(String string) {
        super(string);
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\\.");
        int n = stringArray.length;
        if (n == 3) {
            this.branch = Branch.DEVELOPER;
        } else if (n == 5) {
            this.branch = Branch.STABLE;
        } else if (n == 6) {
            this.branch = Branch.FAKE;
        } else if (n == 4) {
            this.branch = stringArray[0].charAt(0) == 'V' ? Branch.STABLE : Branch.UNKNOWN;
        } else {
            this.isValid = false;
            this.branch = Branch.UNKNOWN;
        }
        this.numbers = this.parseNums(stringArray);
    }

    public static MiuiVersion fromObject(Object object) {
        if (object instanceof String) {
            return new MiuiVersion((String)object);
        }
        if (object instanceof MiuiVersion) {
            return (MiuiVersion)object;
        }
        return null;
    }

    public List<Integer> getNumbers() {
        return this.numbers;
    }

    private List<Integer> parseNums(String[] stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].replaceAll("[^0-9]", "");
            if (!string.isEmpty()) {
                arrayList.add(Integer.parseInt(string));
                continue;
            }
            this.charCode = stringArray[i];
        }
        return arrayList;
    }

    public MiuiVersion$CompareStatus compareTo(MiuiVersion miuiVersion) {
        List<Integer> list = miuiVersion.getNumbers();
        if (list.size() != this.numbers.size()) {
            return MiuiVersion$CompareStatus.CANNOT_COMPARE;
        }
        if (!miuiVersion.isValid || !this.isValid) {
            return MiuiVersion$CompareStatus.CANNOT_COMPARE;
        }
        for (int i = 0; i < this.numbers.size(); ++i) {
            int n;
            int n2 = this.numbers.get(i);
            if (n2 > (n = list.get(i).intValue())) {
                return MiuiVersion$CompareStatus.NEWER;
            }
            if (n <= n2) continue;
            return MiuiVersion$CompareStatus.OLDER;
        }
        return MiuiVersion$CompareStatus.EQUAL;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public String getBigVersion() {
        boolean bl = this.branch == Branch.STABLE || this.branch == Branch.FAKE || this.charCode != null;
        return bl && this.numbers.size() > 0 ? this.numbers.get(0) + "" : "";
    }

    public int getBigVersionNumber() {
        if (this.isValid) {
            if (Branch.STABLE.equals((Object)this.branch) || Branch.FAKE.equals((Object)this.branch) && this.numbers.size() > 0) {
                return this.numbers.get(0);
            }
            return this.compareTo(new MiuiVersion("8.5.25")).equals((Object)MiuiVersion$CompareStatus.NEWER) ? (this.compareTo(new MiuiVersion("9.8.30")).equals((Object)MiuiVersion$CompareStatus.NEWER) ? 11 : 10) : 9;
        }
        return -1;
    }

    @Override
    public String toString() {
        if (!this.isValid) {
            return this.getOrigin();
        }
        boolean bl = this.branch == Branch.STABLE || this.branch == Branch.FAKE || this.charCode != null;
        String string = bl ? "V" : "";
        for (int i = 0; i < this.numbers.size(); ++i) {
            string = string + this.numbers.get(i) + ".";
        }
        if (bl && this.charCode != null) {
            string = string + this.charCode + ".";
        }
        return string.substring(0, string.length() - 1);
    }
}

