/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.cli;

import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;

public class Digest {
    private final String algorithm;
    private final String[] args;
    private final String[] inputs;

    public static void main(String[] stringArray) {
        new Digest(stringArray).run();
    }

    private Digest(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("args");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(String.format("Usage: java %s [algorithm] [FILE|DIRECTORY|string] ...", Digest.class.getName()));
        }
        this.args = stringArray;
        this.algorithm = stringArray[0];
        if (stringArray.length <= 1) {
            this.inputs = null;
        } else {
            this.inputs = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, this.inputs, 0, this.inputs.length);
        }
    }

    private void println(String string, byte[] byArray) {
        this.println(string, byArray, null);
    }

    private void println(String string, byte[] byArray, String string2) {
        System.out.println(string + Hex.encodeHexString(byArray) + (string2 != null ? "  " + string2 : ""));
    }

    private void run() {
        if (this.algorithm.equalsIgnoreCase("ALL") || this.algorithm.equals("*")) {
            this.run(MessageDigestAlgorithms.values());
            return;
        }
        MessageDigest messageDigest = DigestUtils.getDigest((String)this.algorithm, null);
        if (messageDigest != null) {
            this.run("", messageDigest);
        } else {
            this.run("", DigestUtils.getDigest(this.algorithm.toUpperCase(Locale.ROOT)));
        }
    }

    private void run(String[] stringArray) {
        for (String string : stringArray) {
            if (!DigestUtils.isAvailable((String)string)) continue;
            this.run(string + " ", string);
        }
    }

    private void run(String string, MessageDigest messageDigest) {
        if (this.inputs == null) {
            this.println(string, DigestUtils.digest(messageDigest, System.in));
            return;
        }
        for (String string2 : this.inputs) {
            File[] fileArray;
            File file = new File(string2);
            if (file.isFile()) {
                this.println(string, DigestUtils.digest((MessageDigest)messageDigest, (File)file), string2);
                continue;
            }
            if (file.isDirectory()) {
                fileArray = file.listFiles();
                if (fileArray == null) continue;
                this.run(string, messageDigest, fileArray);
                continue;
            }
            fileArray = (File[])string2.getBytes(Charset.defaultCharset());
            this.println(string, DigestUtils.digest((MessageDigest)messageDigest, (byte[])fileArray));
        }
    }

    private void run(String string, MessageDigest messageDigest, File[] fileArray) {
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            this.println(string, DigestUtils.digest((MessageDigest)messageDigest, (File)file), file.getName());
        }
    }

    private void run(String string, String string2) {
        this.run(string, DigestUtils.getDigest(string2));
    }

    public String toString() {
        return String.format("%s %s", super.toString(), Arrays.toString(this.args));
    }
}

