/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.ColognePhonetic$CologneInputBuffer;
import org.apache.commons.codec.language.ColognePhonetic$CologneOutputBuffer;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] SCZ = new char[]{'S', 'C', 'Z'};
    private static final char[] WFPV = new char[]{'W', 'F', 'P', 'V'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHOUKQX = new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'};
    private static final char[] TDX = new char[]{'T', 'D', 'X'};
    private static final char[][] PREPROCESS_MAP = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};

    private static boolean arrayContains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String string) {
        if (string == null) {
            return null;
        }
        string = this.preprocess(string);
        ColognePhonetic$CologneOutputBuffer colognePhonetic$CologneOutputBuffer = new ColognePhonetic$CologneOutputBuffer(this, string.length() * 2);
        ColognePhonetic$CologneInputBuffer colognePhonetic$CologneInputBuffer = new ColognePhonetic$CologneInputBuffer(this, string.toCharArray());
        char c2 = '-';
        int n = 47;
        int n2 = colognePhonetic$CologneInputBuffer.length();
        while (n2 > 0) {
            int n3;
            char c3 = colognePhonetic$CologneInputBuffer.removeNext();
            n2 = colognePhonetic$CologneInputBuffer.length();
            char c4 = n2 > 0 ? (char)colognePhonetic$CologneInputBuffer.getNextChar() : (char)'-';
            if (ColognePhonetic.arrayContains(AEIJOUY, c3)) {
                n3 = 48;
            } else if (c3 == 'H' || c3 < 'A' || c3 > 'Z') {
                if (n == 47) continue;
                n3 = 45;
            } else if (c3 == 'B' || c3 == 'P' && c4 != 'H') {
                n3 = 49;
            } else if (!(c3 != 'D' && c3 != 'T' || ColognePhonetic.arrayContains(SCZ, c4))) {
                n3 = 50;
            } else if (ColognePhonetic.arrayContains(WFPV, c3)) {
                n3 = 51;
            } else if (ColognePhonetic.arrayContains(GKQ, c3)) {
                n3 = 52;
            } else if (c3 == 'X' && !ColognePhonetic.arrayContains(CKQ, c2)) {
                n3 = 52;
                colognePhonetic$CologneInputBuffer.addLeft('S');
                ++n2;
            } else {
                n3 = c3 == 'S' || c3 == 'Z' ? 56 : (c3 == 'C' ? (n == 47 ? (ColognePhonetic.arrayContains(AHKLOQRUX, c4) ? 52 : 56) : (ColognePhonetic.arrayContains(SZ, c2) || !ColognePhonetic.arrayContains(AHOUKQX, c4) ? 56 : 52)) : (ColognePhonetic.arrayContains(TDX, c3) ? 56 : (c3 == 'R' ? 55 : (c3 == 'L' ? 53 : (c3 == 'M' || c3 == 'N' ? 54 : (int)c3)))));
            }
            if (n3 != 45 && (n != n3 && (n3 != 48 || n == 47) || n3 < 48 || n3 > 56)) {
                colognePhonetic$CologneOutputBuffer.addRight((char)n3);
            }
            c2 = c3;
            n = n3;
        }
        return colognePhonetic$CologneOutputBuffer.toString();
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private String preprocess(String string) {
        string = string.toUpperCase(Locale.GERMAN);
        char[] cArray = string.toCharArray();
        block0: for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= 'Z') continue;
            for (char[] cArray2 : PREPROCESS_MAP) {
                if (cArray[i] != cArray2[0]) continue;
                cArray[i] = cArray2[1];
                continue block0;
            }
        }
        return new String(cArray);
    }
}

