/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine$PhonemeBuilder;
import org.apache.commons.codec.language.bm.PhoneticEngine$RulesApplication;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.Rule$Phoneme;
import org.apache.commons.codec.language.bm.RuleType;

public class PhoneticEngine {
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap<NameType, Set<String>>(NameType.class);
    private static final int DEFAULT_MAX_PHONEMES = 20;
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;
    private final int maxPhonemes;

    private static String join(Iterable<String> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl) {
        this(nameType, ruleType, bl, 20);
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl, int n) {
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + (Object)((Object)RuleType.RULES));
        }
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = bl;
        this.lang = Lang.instance(nameType);
        this.maxPhonemes = n;
    }

    private PhoneticEngine$PhonemeBuilder applyFinalRules(PhoneticEngine$PhonemeBuilder phoneticEngine$PhonemeBuilder, Map<String, List<Rule>> map) {
        if (map == null) {
            throw new NullPointerException("finalRules can not be null");
        }
        if (map.isEmpty()) {
            return phoneticEngine$PhonemeBuilder;
        }
        TreeMap<Rule$Phoneme, Rule$Phoneme> treeMap = new TreeMap<Rule$Phoneme, Rule$Phoneme>(Rule$Phoneme.COMPARATOR);
        for (Rule$Phoneme rule$Phoneme : phoneticEngine$PhonemeBuilder.getPhonemes()) {
            PhoneticEngine$PhonemeBuilder phoneticEngine$PhonemeBuilder2 = PhoneticEngine$PhonemeBuilder.empty(rule$Phoneme.getLanguages());
            String string = rule$Phoneme.getPhonemeText().toString();
            int n = 0;
            while (n < string.length()) {
                PhoneticEngine$RulesApplication phoneticEngine$RulesApplication = new PhoneticEngine$RulesApplication(map, string, phoneticEngine$PhonemeBuilder2, n, this.maxPhonemes).invoke();
                boolean bl = phoneticEngine$RulesApplication.isFound();
                phoneticEngine$PhonemeBuilder2 = phoneticEngine$RulesApplication.getPhonemeBuilder();
                if (!bl) {
                    phoneticEngine$PhonemeBuilder2.append(string.subSequence(n, n + 1));
                }
                n = phoneticEngine$RulesApplication.getI();
            }
            for (Rule$Phoneme rule$Phoneme2 : phoneticEngine$PhonemeBuilder2.getPhonemes()) {
                if (treeMap.containsKey(rule$Phoneme2)) {
                    Rule$Phoneme rule$Phoneme3 = (Rule$Phoneme)treeMap.remove(rule$Phoneme2);
                    Rule$Phoneme rule$Phoneme4 = rule$Phoneme3.mergeWithLanguage(rule$Phoneme2.getLanguages());
                    treeMap.put(rule$Phoneme4, rule$Phoneme4);
                    continue;
                }
                treeMap.put(rule$Phoneme2, rule$Phoneme2);
            }
        }
        return new PhoneticEngine$PhonemeBuilder(treeMap.keySet(), null);
    }

    public String encode(String string) {
        Languages$LanguageSet languages$LanguageSet = this.lang.guessLanguages(string);
        return this.encode(string, languages$LanguageSet);
    }

    public String encode(String string, Languages$LanguageSet languages$LanguageSet) {
        Object object3;
        Object object2;
        Map<String, List<Rule>> map = Rule.getInstanceMap(this.nameType, RuleType.RULES, languages$LanguageSet);
        Map<String, List<Rule>> map2 = Rule.getInstanceMap(this.nameType, this.ruleType, "common");
        Map<String, List<Rule>> map3 = Rule.getInstanceMap(this.nameType, this.ruleType, languages$LanguageSet);
        string = string.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (string.length() >= 2 && string.substring(0, 2).equals("d'")) {
                String string2 = string.substring(2);
                String string3 = "d" + string2;
                return "(" + this.encode(string2) + ")-(" + this.encode(string3) + ")";
            }
            for (String object42 : NAME_PREFIXES.get((Object)this.nameType)) {
                if (!string.startsWith(object42 + " ")) continue;
                String object3 = string.substring(object42.length() + 1);
                String object22 = object42 + object3;
                return "(" + this.encode(object3) + ")-(" + this.encode(object22) + ")";
            }
        }
        List<String> list = Arrays.asList(string.split("\\s+"));
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.nameType) {
            case SEPHARDIC: {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    String n = (String)object2.next();
                    object3 = n.split("'");
                    String string2 = object3[((String[])object3).length - 1];
                    arrayList.add(string2);
                }
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case ASHKENAZI: {
                arrayList.addAll(list);
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case GENERIC: {
                arrayList.addAll(list);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + (Object)((Object)this.nameType));
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join(arrayList, " ");
        } else if (arrayList.size() == 1) {
            string = (String)list.iterator().next();
        } else {
            object2 = new StringBuilder();
            for (Object object3 : arrayList) {
                ((StringBuilder)object2).append("-").append(this.encode((String)object3));
            }
            return ((StringBuilder)object2).substring(1);
        }
        object2 = PhoneticEngine$PhonemeBuilder.empty(languages$LanguageSet);
        int n = 0;
        while (n < string.length()) {
            object3 = new PhoneticEngine$RulesApplication(map, string, (PhoneticEngine$PhonemeBuilder)object2, n, this.maxPhonemes).invoke();
            n = ((PhoneticEngine$RulesApplication)object3).getI();
            object2 = ((PhoneticEngine$RulesApplication)object3).getPhonemeBuilder();
        }
        object2 = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object2, map2);
        object2 = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object2, map3);
        return ((PhoneticEngine$PhonemeBuilder)object2).makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    public int getMaxPhonemes() {
        return this.maxPhonemes;
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }
}

