/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.IOException;

public class MemoryLimitException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final long memoryNeededInKb;
    private final int memoryLimitInKb;

    public MemoryLimitException(long l, int n) {
        super(MemoryLimitException.buildMessage(l, n));
        this.memoryNeededInKb = l;
        this.memoryLimitInKb = n;
    }

    public MemoryLimitException(long l, int n, Exception exception) {
        super(MemoryLimitException.buildMessage(l, n), exception);
        this.memoryNeededInKb = l;
        this.memoryLimitInKb = n;
    }

    public long getMemoryNeededInKb() {
        return this.memoryNeededInKb;
    }

    public int getMemoryLimitInKb() {
        return this.memoryLimitInKb;
    }

    private static String buildMessage(long l, int n) {
        return l + " kb of memory would be needed; limit was " + n + " kb. If the file is not corrupt, consider increasing the memory limit.";
    }
}

