/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.File;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveEntry;

public class ArArchiveEntry
implements ArchiveEntry {
    public static final String HEADER = "!<arch>\n";
    public static final String TRAILER = "`\n";
    private final String name;
    private final int userId;
    private final int groupId;
    private final int mode;
    private static final int DEFAULT_MODE = 33188;
    private final long lastModified;
    private final long length;

    public ArArchiveEntry(String string, long l) {
        this(string, l, 0, 0, 33188, System.currentTimeMillis() / 1000L);
    }

    public ArArchiveEntry(String string, long l, int n, int n2, int n3, long l2) {
        this.name = string;
        this.length = l;
        this.userId = n;
        this.groupId = n2;
        this.mode = n3;
        this.lastModified = l2;
    }

    public ArArchiveEntry(File file, String string) {
        this(string, file.isFile() ? file.length() : 0L, 0, 0, 33188, file.lastModified() / 1000L);
    }

    @Override
    public long getSize() {
        return this.getLength();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getMode() {
        return this.mode;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Date getLastModifiedDate() {
        return new Date(1000L * this.getLastModified());
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArArchiveEntry arArchiveEntry = (ArArchiveEntry)object;
        if (this.name == null) {
            return arArchiveEntry.name == null;
        }
        return this.name.equals(arArchiveEntry.name);
    }
}

