/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.archivers.sevenz.Coders$1;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;

class Coders {
    private static final Map<SevenZMethod, CoderBase> CODER_MAP = new Coders$1();

    Coders() {
    }

    static CoderBase findByMethod(SevenZMethod sevenZMethod) {
        return CODER_MAP.get((Object)sevenZMethod);
    }

    static InputStream addDecoder(String string, InputStream inputStream, long l, Coder coder, byte[] byArray) {
        CoderBase coderBase = Coders.findByMethod(SevenZMethod.byId(coder.decompressionMethodId));
        if (coderBase == null) {
            throw new IOException("Unsupported compression method " + Arrays.toString(coder.decompressionMethodId) + " used in " + string);
        }
        return coderBase.decode(string, inputStream, l, coder, byArray);
    }

    static OutputStream addEncoder(OutputStream outputStream, SevenZMethod sevenZMethod, Object object) {
        CoderBase coderBase = Coders.findByMethod(sevenZMethod);
        if (coderBase == null) {
            throw new IOException("Unsupported compression method " + (Object)((Object)sevenZMethod));
        }
        return coderBase.encode(outputStream, object);
    }
}

