/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BinaryTree;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.archivers.zip.CircularBuffer;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream$1;
import org.apache.commons.compress.utils.InputStreamStatistics;

class ExplodingInputStream
extends InputStream
implements InputStreamStatistics {
    private final InputStream in;
    private BitStream bits;
    private final int dictionarySize;
    private final int numberOfTrees;
    private final int minimumMatchLength;
    private BinaryTree literalTree;
    private BinaryTree lengthTree;
    private BinaryTree distanceTree;
    private final CircularBuffer buffer = new CircularBuffer(32768);
    private long uncompressedCount = 0L;
    private long treeSizes = 0L;

    public ExplodingInputStream(int n, int n2, InputStream inputStream) {
        if (n != 4096 && n != 8192) {
            throw new IllegalArgumentException("The dictionary size must be 4096 or 8192");
        }
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("The number of trees must be 2 or 3");
        }
        this.dictionarySize = n;
        this.numberOfTrees = n2;
        this.minimumMatchLength = n2;
        this.in = inputStream;
    }

    private void init() {
        if (this.bits == null) {
            try (ExplodingInputStream$1 explodingInputStream$1 = new ExplodingInputStream$1(this, this.in);){
                if (this.numberOfTrees == 3) {
                    this.literalTree = BinaryTree.decode(explodingInputStream$1, 256);
                }
                this.lengthTree = BinaryTree.decode(explodingInputStream$1, 64);
                this.distanceTree = BinaryTree.decode(explodingInputStream$1, 64);
                this.treeSizes += explodingInputStream$1.getBytesRead();
            }
            this.bits = new BitStream(this.in);
        }
    }

    @Override
    public int read() {
        int n;
        if (!this.buffer.available()) {
            this.fillBuffer();
        }
        if ((n = this.buffer.get()) > -1) {
            ++this.uncompressedCount;
        }
        return n;
    }

    @Override
    public long getCompressedCount() {
        return this.bits.getBytesRead() + this.treeSizes;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }

    @Override
    public void close() {
        this.in.close();
    }

    private void fillBuffer() {
        this.init();
        int n = this.bits.nextBit();
        if (n == 1) {
            int n2 = this.literalTree != null ? this.literalTree.read(this.bits) : this.bits.nextByte();
            if (n2 == -1) {
                return;
            }
            this.buffer.put(n2);
        } else if (n == 0) {
            int n3 = this.dictionarySize == 4096 ? 6 : 7;
            int n4 = (int)this.bits.nextBits(n3);
            int n5 = this.distanceTree.read(this.bits);
            if (n5 == -1 && n4 <= 0) {
                return;
            }
            int n6 = n5 << n3 | n4;
            int n7 = this.lengthTree.read(this.bits);
            if (n7 == 63) {
                n7 = (int)((long)n7 + this.bits.nextBits(8));
            }
            this.buffer.copy(n6 + 1, n7 += this.minimumMatchLength);
        }
    }
}

