/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.utils.InputStreamStatistics;

class InflaterInputStreamWithStatistics
extends InflaterInputStream
implements InputStreamStatistics {
    private long compressedCount = 0L;
    private long uncompressedCount = 0L;

    public InflaterInputStreamWithStatistics(InputStream inputStream) {
        super(inputStream);
    }

    public InflaterInputStreamWithStatistics(InputStream inputStream, Inflater inflater) {
        super(inputStream, inflater);
    }

    public InflaterInputStreamWithStatistics(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream, inflater, n);
    }

    @Override
    protected void fill() {
        super.fill();
        this.compressedCount += (long)this.inf.getRemaining();
    }

    @Override
    public int read() {
        int n = super.read();
        if (n > -1) {
            ++this.uncompressedCount;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = super.read(byArray, n, n2);
        if (n3 > -1) {
            this.uncompressedCount += (long)n3;
        }
        return n3;
    }

    @Override
    public long getCompressedCount() {
        return this.compressedCount;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }
}

