/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.commons.compress.archivers.zip.CharsetAccessor;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

class NioZipEncoding
implements CharsetAccessor,
ZipEncoding {
    private final Charset charset;
    private final boolean useReplacement;
    private static final char REPLACEMENT = '?';
    private static final byte[] REPLACEMENT_BYTES = new byte[]{63};
    private static final String REPLACEMENT_STRING = String.valueOf('?');
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    NioZipEncoding(Charset charset, boolean bl) {
        this.charset = charset;
        this.useReplacement = bl;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean canEncode(String string) {
        CharsetEncoder charsetEncoder = this.newEncoder();
        return charsetEncoder.canEncode(string);
    }

    @Override
    public ByteBuffer encode(String string) {
        CharsetEncoder charsetEncoder = this.newEncoder();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        CharBuffer charBuffer2 = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(NioZipEncoding.estimateInitialBufferSize(charsetEncoder, charBuffer.remaining()));
        while (charBuffer.remaining() > 0) {
            int n;
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, false);
            if (coderResult.isUnmappable() || coderResult.isMalformed()) {
                int n2;
                n = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, 6 * coderResult.length());
                if (n > byteBuffer.remaining()) {
                    int n3;
                    n2 = 0;
                    for (n3 = charBuffer.position(); n3 < charBuffer.limit(); ++n3) {
                        n2 += !charsetEncoder.canEncode(charBuffer.get(n3)) ? 6 : 1;
                    }
                    n3 = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, n2);
                    byteBuffer = ZipEncodingHelper.growBufferBy(byteBuffer, n3 - byteBuffer.remaining());
                }
                if (charBuffer2 == null) {
                    charBuffer2 = CharBuffer.allocate(6);
                }
                for (n2 = 0; n2 < coderResult.length(); ++n2) {
                    byteBuffer = NioZipEncoding.encodeFully(charsetEncoder, NioZipEncoding.encodeSurrogate(charBuffer2, charBuffer.get()), byteBuffer);
                }
                continue;
            }
            if (!coderResult.isOverflow()) continue;
            n = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, charBuffer.remaining());
            byteBuffer = ZipEncodingHelper.growBufferBy(byteBuffer, n);
        }
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public String decode(byte[] byArray) {
        return this.newDecoder().decode(ByteBuffer.wrap(byArray)).toString();
    }

    private static ByteBuffer encodeFully(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        while (charBuffer.hasRemaining()) {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer2, false);
            if (!coderResult.isOverflow()) continue;
            int n = NioZipEncoding.estimateIncrementalEncodingSize(charsetEncoder, charBuffer.remaining());
            byteBuffer2 = ZipEncodingHelper.growBufferBy(byteBuffer2, n);
        }
        return byteBuffer2;
    }

    private static CharBuffer encodeSurrogate(CharBuffer charBuffer, char c2) {
        charBuffer.position(0).limit(6);
        charBuffer.put('%');
        charBuffer.put('U');
        charBuffer.put(HEX_CHARS[c2 >> 12 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 >> 8 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 >> 4 & 0xF]);
        charBuffer.put(HEX_CHARS[c2 & 0xF]);
        charBuffer.flip();
        return charBuffer;
    }

    private CharsetEncoder newEncoder() {
        if (this.useReplacement) {
            return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_BYTES);
        }
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private CharsetDecoder newDecoder() {
        if (!this.useReplacement) {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_STRING);
    }

    private static int estimateInitialBufferSize(CharsetEncoder charsetEncoder, int n) {
        float f2 = charsetEncoder.maxBytesPerChar();
        float f3 = (float)(n - 1) * charsetEncoder.averageBytesPerChar();
        return (int)Math.ceil(f2 + f3);
    }

    private static int estimateIncrementalEncodingSize(CharsetEncoder charsetEncoder, int n) {
        return (int)Math.ceil((float)n * charsetEncoder.averageBytesPerChar());
    }
}

