/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator$1;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator$2;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator$3;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator$DefaultBackingStoreSupplier;
import org.apache.commons.compress.archivers.zip.ScatterStatistics;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;

public class ParallelScatterZipCreator {
    private final List<ScatterZipOutputStream> streams = Collections.synchronizedList(new ArrayList());
    private final ExecutorService es;
    private final ScatterGatherBackingStoreSupplier backingStoreSupplier;
    private final List<Future<Object>> futures = new ArrayList<Future<Object>>();
    private final long startedAt = System.currentTimeMillis();
    private long compressionDoneAt = 0L;
    private long scatterDoneAt;
    private final ThreadLocal<ScatterZipOutputStream> tlScatterStreams = new ParallelScatterZipCreator$1(this);

    private ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) {
        ScatterGatherBackingStore scatterGatherBackingStore = scatterGatherBackingStoreSupplier.get();
        StreamCompressor streamCompressor = StreamCompressor.create(-1, scatterGatherBackingStore);
        return new ScatterZipOutputStream(scatterGatherBackingStore, streamCompressor);
    }

    public ParallelScatterZipCreator() {
        this(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public ParallelScatterZipCreator(ExecutorService executorService) {
        this(executorService, new ParallelScatterZipCreator$DefaultBackingStoreSupplier());
    }

    public ParallelScatterZipCreator(ExecutorService executorService, ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) {
        this.backingStoreSupplier = scatterGatherBackingStoreSupplier;
        this.es = executorService;
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier inputStreamSupplier) {
        this.submit(this.createCallable(zipArchiveEntry, inputStreamSupplier));
    }

    public void addArchiveEntry(ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        this.submit(this.createCallable(zipArchiveEntryRequestSupplier));
    }

    public final void submit(Callable<Object> callable) {
        this.futures.add(this.es.submit(callable));
    }

    public final Callable<Object> createCallable(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier inputStreamSupplier) {
        int n = zipArchiveEntry.getMethod();
        if (n == -1) {
            throw new IllegalArgumentException("Method must be set on zipArchiveEntry: " + zipArchiveEntry);
        }
        ZipArchiveEntryRequest zipArchiveEntryRequest = ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, inputStreamSupplier);
        return new ParallelScatterZipCreator$2(this, zipArchiveEntryRequest);
    }

    public final Callable<Object> createCallable(ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        return new ParallelScatterZipCreator$3(this, zipArchiveEntryRequestSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ZipArchiveOutputStream zipArchiveOutputStream) {
        try {
            for (Future<Object> object : this.futures) {
                object.get();
            }
        }
        finally {
            this.es.shutdown();
        }
        this.es.awaitTermination(60000L, TimeUnit.SECONDS);
        this.compressionDoneAt = System.currentTimeMillis();
        List<ScatterZipOutputStream> list = this.streams;
        synchronized (list) {
            for (ScatterZipOutputStream scatterZipOutputStream : this.streams) {
                scatterZipOutputStream.writeTo(zipArchiveOutputStream);
                scatterZipOutputStream.close();
            }
        }
        this.scatterDoneAt = System.currentTimeMillis();
    }

    public ScatterStatistics getStatisticsMessage() {
        return new ScatterStatistics(this.compressionDoneAt - this.startedAt, this.scatterDoneAt - this.compressionDoneAt);
    }

    static /* synthetic */ ScatterGatherBackingStoreSupplier access$000(ParallelScatterZipCreator parallelScatterZipCreator) {
        return parallelScatterZipCreator.backingStoreSupplier;
    }

    static /* synthetic */ ScatterZipOutputStream access$100(ParallelScatterZipCreator parallelScatterZipCreator, ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) {
        return parallelScatterZipCreator.createDeferred(scatterGatherBackingStoreSupplier);
    }

    static /* synthetic */ List access$200(ParallelScatterZipCreator parallelScatterZipCreator) {
        return parallelScatterZipCreator.streams;
    }

    static /* synthetic */ ThreadLocal access$400(ParallelScatterZipCreator parallelScatterZipCreator) {
        return parallelScatterZipCreator.tlScatterStreams;
    }
}

