/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.compressors.lzw.LZWInputStream;

class UnshrinkingInputStream
extends LZWInputStream {
    private static final int MAX_CODE_SIZE = 13;
    private static final int MAX_TABLE_SIZE = 8192;
    private final boolean[] isUsed;

    public UnshrinkingInputStream(InputStream inputStream) {
        super(inputStream, ByteOrder.LITTLE_ENDIAN);
        this.setClearCode(9);
        this.initializeTables(13);
        this.isUsed = new boolean[this.getPrefixesLength()];
        for (int i = 0; i < 256; ++i) {
            this.isUsed[i] = true;
        }
        this.setTableSize(this.getClearCode() + 1);
    }

    @Override
    protected int addEntry(int n, byte by) {
        int n2;
        for (n2 = this.getTableSize(); n2 < 8192 && this.isUsed[n2]; ++n2) {
        }
        this.setTableSize(n2);
        int n3 = this.addEntry(n, by, 8192);
        if (n3 >= 0) {
            this.isUsed[n3] = true;
        }
        return n3;
    }

    private void partialClear() {
        int n;
        boolean[] blArray = new boolean[8192];
        for (n = 0; n < this.isUsed.length; ++n) {
            if (!this.isUsed[n] || this.getPrefix(n) == -1) continue;
            blArray[this.getPrefix((int)n)] = true;
        }
        for (n = this.getClearCode() + 1; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            this.isUsed[n] = false;
            this.setPrefix(n, -1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int decompressNextSymbol() {
        int n = this.readNextCode();
        if (n < 0) {
            return -1;
        }
        if (n == this.getClearCode()) {
            int n2 = this.readNextCode();
            if (n2 < 0) {
                throw new IOException("Unexpected EOF;");
            }
            if (n2 == 1) {
                if (this.getCodeSize() >= 13) throw new IOException("Attempt to increase code size beyond maximum");
                this.incrementCodeSize();
                return 0;
            } else {
                if (n2 != 2) throw new IOException("Invalid clear code subcode " + n2);
                this.partialClear();
                this.setTableSize(this.getClearCode() + 1);
            }
            return 0;
        }
        boolean bl = false;
        int n3 = n;
        if (this.isUsed[n]) return this.expandCodeToOutputStack(n3, bl);
        n3 = this.addRepeatOfPreviousCode();
        bl = true;
        return this.expandCodeToOutputStack(n3, bl);
    }
}

