/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException$Feature;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry$NameSource;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream$BoundedInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream$CurrentEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class ZipArchiveInputStream
extends ArchiveInputStream
implements InputStreamStatistics {
    private final ZipEncoding zipEncoding;
    final String encoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final ByteBuffer buf = ByteBuffer.allocate(512);
    private ZipArchiveInputStream$CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private long uncompressedCount = 0L;
    private static final int LFH_LEN = 30;
    private static final int CFH_LEN = 46;
    private static final long TWO_EXP_32 = 0x100000000L;
    private final byte[] lfhBuf = new byte[30];
    private final byte[] skipBuf = new byte[1024];
    private final byte[] shortBuf = new byte[2];
    private final byte[] wordBuf = new byte[4];
    private final byte[] twoDwordBuf = new byte[16];
    private int entriesRead = 0;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8");
    }

    public ZipArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl) {
        this(inputStream, string, bl, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl, boolean bl2) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl;
        this.in = new PushbackInputStream(inputStream, this.buf.capacity());
        this.allowStoredEntriesWithDataDescriptor = bl2;
        this.buf.limit(0);
    }

    public ZipArchiveEntry getNextZipEntry() {
        this.uncompressedCount = 0L;
        boolean bl = true;
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
            bl = false;
        }
        long l = this.getBytesRead();
        try {
            if (bl) {
                this.readFirstLocalFileHeader(this.lfhBuf);
            } else {
                this.readFully(this.lfhBuf);
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        ZipLong zipLong = new ZipLong(this.lfhBuf);
        if (zipLong.equals(ZipLong.CFH_SIG) || zipLong.equals(ZipLong.AED_SIG)) {
            this.hitCentralDirectory = true;
            this.skipRemainderOfArchive();
            return null;
        }
        if (!zipLong.equals(ZipLong.LFH_SIG)) {
            throw new ZipException(String.format("Unexpected record signature: 0X%X", zipLong.getValue()));
        }
        int n = 4;
        this.current = new ZipArchiveInputStream$CurrentEntry(null);
        int n2 = ZipShort.getValue(this.lfhBuf, n);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setPlatform(n2 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.lfhBuf, n += 2);
        boolean bl2 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl2 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ZipArchiveInputStream$CurrentEntry.access$202(this.current, generalPurposeBit.usesDataDescriptor());
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setGeneralPurposeBit(generalPurposeBit);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setMethod(ZipShort.getValue(this.lfhBuf, n += 2));
        long l2 = ZipUtil.dosToJavaTime(ZipLong.getValue(this.lfhBuf, n += 2));
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setTime(l2);
        n += 4;
        ZipLong zipLong2 = null;
        ZipLong zipLong3 = null;
        if (!ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCrc(ZipLong.getValue(this.lfhBuf, n));
            zipLong3 = new ZipLong(this.lfhBuf, n += 4);
            zipLong2 = new ZipLong(this.lfhBuf, n += 4);
            n += 4;
        } else {
            n += 12;
        }
        int n3 = ZipShort.getValue(this.lfhBuf, n);
        int n4 = ZipShort.getValue(this.lfhBuf, n += 2);
        n += 2;
        byte[] byArray = new byte[n3];
        this.readFully(byArray);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setName(zipEncoding.decode(byArray), byArray);
        if (bl2) {
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setNameSource(ZipArchiveEntry$NameSource.NAME_WITH_EFS_FLAG);
        }
        byte[] byArray2 = new byte[n4];
        this.readFully(byArray2);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setExtra(byArray2);
        if (!bl2 && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(ZipArchiveInputStream$CurrentEntry.access$100(this.current), byArray, null);
        }
        this.processZip64Extra(zipLong2, zipLong3);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setLocalHeaderOffset(l);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setDataOffset(this.getBytesRead());
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setStreamContiguous(true);
        ZipMethod zipMethod = ZipMethod.getMethodByCode(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod());
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() != -1L) {
            if (ZipUtil.canHandleEntryData(ZipArchiveInputStream$CurrentEntry.access$100(this.current)) && zipMethod != ZipMethod.STORED && zipMethod != ZipMethod.DEFLATED) {
                ZipArchiveInputStream$BoundedInputStream zipArchiveInputStream$BoundedInputStream = new ZipArchiveInputStream$BoundedInputStream(this, this.in, ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize());
                switch (zipMethod) {
                    case UNSHRINKING: {
                        ZipArchiveInputStream$CurrentEntry.access$302(this.current, new UnshrinkingInputStream(zipArchiveInputStream$BoundedInputStream));
                        break;
                    }
                    case IMPLODING: {
                        ZipArchiveInputStream$CurrentEntry.access$302(this.current, new ExplodingInputStream(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getGeneralPurposeBit().getSlidingDictionarySize(), ZipArchiveInputStream$CurrentEntry.access$100(this.current).getGeneralPurposeBit().getNumberOfShannonFanoTrees(), zipArchiveInputStream$BoundedInputStream));
                        break;
                    }
                    case BZIP2: {
                        ZipArchiveInputStream$CurrentEntry.access$302(this.current, new BZip2CompressorInputStream(zipArchiveInputStream$BoundedInputStream));
                        break;
                    }
                    case ENHANCED_DEFLATED: {
                        ZipArchiveInputStream$CurrentEntry.access$302(this.current, new Deflate64CompressorInputStream(zipArchiveInputStream$BoundedInputStream));
                        break;
                    }
                }
            }
        } else if (zipMethod == ZipMethod.ENHANCED_DEFLATED) {
            ZipArchiveInputStream$CurrentEntry.access$302(this.current, new Deflate64CompressorInputStream(this.in));
        }
        ++this.entriesRead;
        return ZipArchiveInputStream$CurrentEntry.access$100(this.current);
    }

    private void readFirstLocalFileHeader(byte[] byArray) {
        this.readFully(byArray);
        ZipLong zipLong = new ZipLong(byArray);
        if (zipLong.equals(ZipLong.DD_SIG)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException$Feature.SPLITTING);
        }
        if (zipLong.equals(ZipLong.SINGLE_SEGMENT_SPLIT_MARKER)) {
            byte[] byArray2 = new byte[4];
            this.readFully(byArray2);
            System.arraycopy(byArray, 4, byArray, 0, 26);
            System.arraycopy(byArray2, 0, byArray, 26, 4);
        }
    }

    private void processZip64Extra(ZipLong zipLong, ZipLong zipLong2) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)ZipArchiveInputStream$CurrentEntry.access$100(this.current).getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        ZipArchiveInputStream$CurrentEntry.access$402(this.current, zip64ExtendedInformationExtraField != null);
        if (!ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            if (zip64ExtendedInformationExtraField != null && (zipLong2.equals(ZipLong.ZIP64_MAGIC) || zipLong.equals(ZipLong.ZIP64_MAGIC))) {
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else {
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(zipLong2.getValue());
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(zipLong.getValue());
            }
        }
    }

    @Override
    public ArchiveEntry getNextEntry() {
        return this.getNextZipEntry();
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return ZipUtil.canHandleEntryData(zipArchiveEntry) && this.supportsDataDescriptorFor(zipArchiveEntry) && this.supportsCompressedSizeFor(zipArchiveEntry);
        }
        return false;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return -1;
        }
        if (n > byArray.length || n2 < 0 || n < 0 || byArray.length - n < n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZipUtil.checkRequestedFeatures(ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        if (!this.supportsDataDescriptorFor(ZipArchiveInputStream$CurrentEntry.access$100(this.current))) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException$Feature.DATA_DESCRIPTOR, ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        }
        if (!this.supportsCompressedSizeFor(ZipArchiveInputStream$CurrentEntry.access$100(this.current))) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException$Feature.UNKNOWN_COMPRESSED_SIZE, ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 0) {
            n3 = this.readStored(byArray, n, n2);
        } else if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 8) {
            n3 = this.readDeflated(byArray, n, n2);
        } else if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.UNSHRINKING.getCode() || ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.IMPLODING.getCode() || ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.BZIP2.getCode()) {
            n3 = ZipArchiveInputStream$CurrentEntry.access$300(this.current).read(byArray, n, n2);
        } else {
            throw new UnsupportedZipFeatureException(ZipMethod.getMethodByCode(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod()), ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        }
        if (n3 >= 0) {
            ZipArchiveInputStream$CurrentEntry.access$500(this.current).update(byArray, n, n3);
            this.uncompressedCount += (long)n3;
        }
        return n3;
    }

    @Override
    public long getCompressedCount() {
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 0) {
            return ZipArchiveInputStream$CurrentEntry.access$600(this.current);
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 8) {
            return this.getBytesInflated();
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.UNSHRINKING.getCode()) {
            return ((UnshrinkingInputStream)ZipArchiveInputStream$CurrentEntry.access$300(this.current)).getCompressedCount();
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.IMPLODING.getCode()) {
            return ((ExplodingInputStream)ZipArchiveInputStream$CurrentEntry.access$300(this.current)).getCompressedCount();
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode()) {
            return ((Deflate64CompressorInputStream)ZipArchiveInputStream$CurrentEntry.access$300(this.current)).getCompressedCount();
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.BZIP2.getCode()) {
            return ((BZip2CompressorInputStream)ZipArchiveInputStream$CurrentEntry.access$300(this.current)).getCompressedCount();
        }
        return -1L;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }

    private int readStored(byte[] byArray, int n, int n2) {
        ZipArchiveInputStream$CurrentEntry zipArchiveInputStream$CurrentEntry;
        int n3;
        if (ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(byArray, n, n2);
        }
        long l = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getSize();
        if (ZipArchiveInputStream$CurrentEntry.access$600(this.current) >= l) {
            return -1;
        }
        if (this.buf.position() >= this.buf.limit()) {
            this.buf.position(0);
            n3 = this.in.read(this.buf.array());
            if (n3 == -1) {
                return -1;
            }
            this.buf.limit(n3);
            this.count(n3);
            zipArchiveInputStream$CurrentEntry = this.current;
            ZipArchiveInputStream$CurrentEntry.access$702(zipArchiveInputStream$CurrentEntry, ZipArchiveInputStream$CurrentEntry.access$700(zipArchiveInputStream$CurrentEntry) + (long)n3);
        }
        n3 = Math.min(this.buf.remaining(), n2);
        if (l - ZipArchiveInputStream$CurrentEntry.access$600(this.current) < (long)n3) {
            n3 = (int)(l - ZipArchiveInputStream$CurrentEntry.access$600(this.current));
        }
        this.buf.get(byArray, n, n3);
        zipArchiveInputStream$CurrentEntry = this.current;
        ZipArchiveInputStream$CurrentEntry.access$602(zipArchiveInputStream$CurrentEntry, ZipArchiveInputStream$CurrentEntry.access$600(zipArchiveInputStream$CurrentEntry) + (long)n3);
        return n3;
    }

    private int readDeflated(byte[] byArray, int n, int n2) {
        int n3 = this.readFromInflater(byArray, n, n2);
        if (n3 <= 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("This archive needs a preset dictionary which is not supported by Commons Compress.");
            }
            if (n3 == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        return n3;
    }

    private int readFromInflater(byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            if (this.inf.needsInput()) {
                int n4 = this.fill();
                if (n4 > 0) {
                    ZipArchiveInputStream$CurrentEntry zipArchiveInputStream$CurrentEntry = this.current;
                    ZipArchiveInputStream$CurrentEntry.access$702(zipArchiveInputStream$CurrentEntry, ZipArchiveInputStream$CurrentEntry.access$700(zipArchiveInputStream$CurrentEntry) + (long)this.buf.limit());
                } else {
                    if (n4 != -1) break;
                    return -1;
                }
            }
            try {
                n3 = this.inf.inflate(byArray, n, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new ZipException(dataFormatException.getMessage()).initCause(dataFormatException);
            }
        } while (n3 == 0 && this.inf.needsInput());
        return n3;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.in.close();
            }
            finally {
                this.inf.end();
            }
        }
    }

    @Override
    public long skip(long l) {
        if (l >= 0L) {
            long l2;
            int n;
            for (l2 = 0L; l2 < l; l2 += (long)n) {
                long l3 = l - l2;
                n = this.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l3 ? l3 : (long)this.skipBuf.length));
                if (n != -1) continue;
                return l2;
            }
            return l2;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.EOCD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.DD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipLong.SINGLE_SEGMENT_SPLIT_MARKER.getBytes());
    }

    private static boolean checksig(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (this.currentEntryHasOutstandingBytes()) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long l = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 8 ? this.getBytesInflated() : ZipArchiveInputStream$CurrentEntry.access$600(this.current);
            int n = (int)(ZipArchiveInputStream$CurrentEntry.access$700(this.current) - l);
            if (n > 0) {
                this.pushback(this.buf.array(), this.buf.limit() - n, n);
                ZipArchiveInputStream$CurrentEntry zipArchiveInputStream$CurrentEntry = this.current;
                ZipArchiveInputStream$CurrentEntry.access$702(zipArchiveInputStream$CurrentEntry, ZipArchiveInputStream$CurrentEntry.access$700(zipArchiveInputStream$CurrentEntry) - (long)n);
            }
            if (this.currentEntryHasOutstandingBytes()) {
                this.drainCurrentEntryData();
            }
        }
        if (this.lastStoredEntry == null && ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.buf.clear().flip();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private boolean currentEntryHasOutstandingBytes() {
        return ZipArchiveInputStream$CurrentEntry.access$700(this.current) <= ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() && !ZipArchiveInputStream$CurrentEntry.access$200(this.current);
    }

    private void drainCurrentEntryData() {
        long l;
        for (long i = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() - ZipArchiveInputStream$CurrentEntry.access$700(this.current); i > 0L; i -= l) {
            l = this.in.read(this.buf.array(), 0, (int)Math.min((long)this.buf.capacity(), i));
            if (l < 0L) {
                throw new EOFException("Truncated ZIP entry: " + ArchiveUtils.sanitize(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getName()));
            }
            this.count(l);
        }
    }

    private long getBytesInflated() {
        long l = this.inf.getBytesRead();
        if (ZipArchiveInputStream$CurrentEntry.access$700(this.current) >= 0x100000000L) {
            while (l + 0x100000000L <= ZipArchiveInputStream$CurrentEntry.access$700(this.current)) {
                l += 0x100000000L;
            }
        }
        return l;
    }

    private int fill() {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        int n = this.in.read(this.buf.array());
        if (n > 0) {
            this.buf.limit(n);
            this.count(this.buf.limit());
            this.inf.setInput(this.buf.array(), 0, this.buf.limit());
        }
        return n;
    }

    private void readFully(byte[] byArray) {
        int n = IOUtils.readFully(this.in, byArray);
        this.count(n);
        if (n < byArray.length) {
            throw new EOFException();
        }
    }

    private void readDataDescriptor() {
        this.readFully(this.wordBuf);
        ZipLong zipLong = new ZipLong(this.wordBuf);
        if (ZipLong.DD_SIG.equals(zipLong)) {
            this.readFully(this.wordBuf);
            zipLong = new ZipLong(this.wordBuf);
        }
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCrc(zipLong.getValue());
        this.readFully(this.twoDwordBuf);
        ZipLong zipLong2 = new ZipLong(this.twoDwordBuf, 8);
        if (zipLong2.equals(ZipLong.CFH_SIG) || zipLong2.equals(ZipLong.LFH_SIG)) {
            this.pushback(this.twoDwordBuf, 8, 8);
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(ZipLong.getValue(this.twoDwordBuf));
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(ZipLong.getValue(this.twoDwordBuf, 4));
        } else {
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf));
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf, 8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry zipArchiveEntry) {
        return !zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() || this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0 || zipArchiveEntry.getMethod() == 8 || zipArchiveEntry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode();
    }

    private boolean supportsCompressedSizeFor(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getCompressedSize() != -1L || zipArchiveEntry.getMethod() == 8 || zipArchiveEntry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() && this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0;
    }

    private void readStoredEntry() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        boolean bl = false;
        int n3 = n = ZipArchiveInputStream$CurrentEntry.access$400(this.current) ? 20 : 12;
        while (!bl) {
            int n4 = this.in.read(this.buf.array(), n2, 512 - n2);
            if (n4 <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (n4 + n2 < 4) {
                n2 += n4;
                continue;
            }
            bl = this.bufferContainsSignature(byteArrayOutputStream, n2, n4, n);
            if (bl) continue;
            n2 = this.cacheBytesRead(byteArrayOutputStream, n2, n4, n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(byArray);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        for (int i = 0; !bl && i < n + n2 - 4; ++i) {
            if (this.buf.array()[i] != LFH[0] || this.buf.array()[i + 1] != LFH[1]) continue;
            if (this.buf.array()[i + 2] == LFH[2] && this.buf.array()[i + 3] == LFH[3] || this.buf.array()[i] == CFH[2] && this.buf.array()[i + 3] == CFH[3]) {
                n4 = n + n2 - i - n3;
                bl = true;
            } else if (this.buf.array()[i + 2] == DD[2] && this.buf.array()[i + 3] == DD[3]) {
                n4 = n + n2 - i;
                bl = true;
            }
            if (!bl) continue;
            this.pushback(this.buf.array(), n + n2 - n4, n4);
            byteArrayOutputStream.write(this.buf.array(), 0, i);
            this.readDataDescriptor();
        }
        return bl;
    }

    private int cacheBytesRead(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3) {
        int n4 = n + n2 - n3 - 3;
        if (n4 > 0) {
            byteArrayOutputStream.write(this.buf.array(), 0, n4);
            System.arraycopy(this.buf.array(), n4, this.buf.array(), 0, n3 + 3);
            n = n3 + 3;
        } else {
            n += n2;
        }
        return n;
    }

    private void pushback(byte[] byArray, int n, int n2) {
        ((PushbackInputStream)this.in).unread(byArray, n, n2);
        this.pushedBackBytes(n2);
    }

    private void skipRemainderOfArchive() {
        this.realSkip((long)this.entriesRead * 46L - 30L);
        this.findEocdRecord();
        this.realSkip(16L);
        this.readFully(this.shortBuf);
        this.realSkip(ZipShort.getValue(this.shortBuf));
    }

    private void findEocdRecord() {
        int n = -1;
        boolean bl = false;
        while (bl || (n = this.readOneByte()) > -1) {
            bl = false;
            if (!this.isFirstByteOfEocdSig(n)) continue;
            n = this.readOneByte();
            if (n != ZipArchiveOutputStream.EOCD_SIG[1]) {
                if (n == -1) break;
                bl = this.isFirstByteOfEocdSig(n);
                continue;
            }
            n = this.readOneByte();
            if (n != ZipArchiveOutputStream.EOCD_SIG[2]) {
                if (n == -1) break;
                bl = this.isFirstByteOfEocdSig(n);
                continue;
            }
            n = this.readOneByte();
            if (n == -1 || n == ZipArchiveOutputStream.EOCD_SIG[3]) break;
            bl = this.isFirstByteOfEocdSig(n);
        }
    }

    private void realSkip(long l) {
        if (l >= 0L) {
            int n;
            for (long i = 0L; i < l; i += (long)n) {
                long l2 = l - i;
                n = this.in.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l2 ? l2 : (long)this.skipBuf.length));
                if (n == -1) {
                    return;
                }
                this.count(n);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private int readOneByte() {
        int n = this.in.read();
        if (n != -1) {
            this.count(1);
        }
        return n;
    }

    private boolean isFirstByteOfEocdSig(int n) {
        return n == ZipArchiveOutputStream.EOCD_SIG[0];
    }

    static /* synthetic */ void access$800(ZipArchiveInputStream zipArchiveInputStream, int n) {
        zipArchiveInputStream.count(n);
    }

    static /* synthetic */ ZipArchiveInputStream$CurrentEntry access$900(ZipArchiveInputStream zipArchiveInputStream) {
        return zipArchiveInputStream.current;
    }

    static /* synthetic */ void access$1000(ZipArchiveInputStream zipArchiveInputStream, int n) {
        zipArchiveInputStream.count(n);
    }
}

