/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import org.apache.commons.compress.utils.ByteUtils;

public final class ZipLong
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final long value;
    public static final ZipLong CFH_SIG = new ZipLong(33639248L);
    public static final ZipLong LFH_SIG = new ZipLong(67324752L);
    public static final ZipLong DD_SIG = new ZipLong(134695760L);
    static final ZipLong ZIP64_MAGIC = new ZipLong(0xFFFFFFFFL);
    public static final ZipLong SINGLE_SEGMENT_SPLIT_MARKER = new ZipLong(808471376L);
    public static final ZipLong AED_SIG = new ZipLong(134630224L);

    public ZipLong(long l) {
        this.value = l;
    }

    public ZipLong(int n) {
        this.value = n;
    }

    public ZipLong(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipLong(byte[] byArray, int n) {
        this.value = ZipLong.getValue(byArray, n);
    }

    public byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public static byte[] getBytes(long l) {
        byte[] byArray = new byte[4];
        ZipLong.putLong(l, byArray, 0);
        return byArray;
    }

    public static void putLong(long l, byte[] byArray, int n) {
        ByteUtils.toLittleEndian(byArray, l, n, 4);
    }

    public void putLong(byte[] byArray, int n) {
        ZipLong.putLong(this.value, byArray, n);
    }

    public static long getValue(byte[] byArray, int n) {
        return ByteUtils.fromLittleEndian(byArray, n, 4);
    }

    public static long getValue(byte[] byArray) {
        return ZipLong.getValue(byArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)object).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return "ZipLong value: " + this.value;
    }
}

