/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer$ArchiveEntryIterator;
import org.apache.commons.compress.changes.ChangeSetPerformer$ArchiveInputStreamIterator;
import org.apache.commons.compress.changes.ChangeSetPerformer$ZipFileIterator;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.apache.commons.compress.utils.IOUtils;

public class ChangeSetPerformer {
    private final Set<Change> changes;

    public ChangeSetPerformer(ChangeSet changeSet) {
        this.changes = changeSet.getChanges();
    }

    public ChangeSetResults perform(ArchiveInputStream archiveInputStream, ArchiveOutputStream archiveOutputStream) {
        return this.perform(new ChangeSetPerformer$ArchiveInputStreamIterator(archiveInputStream), archiveOutputStream);
    }

    public ChangeSetResults perform(ZipFile zipFile, ArchiveOutputStream archiveOutputStream) {
        return this.perform(new ChangeSetPerformer$ZipFileIterator(zipFile), archiveOutputStream);
    }

    private ChangeSetResults perform(ChangeSetPerformer$ArchiveEntryIterator changeSetPerformer$ArchiveEntryIterator, ArchiveOutputStream archiveOutputStream) {
        ChangeSetResults changeSetResults = new ChangeSetResults();
        LinkedHashSet<Change> linkedHashSet = new LinkedHashSet<Change>(this.changes);
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Change change = (Change)iterator.next();
            if (change.type() != 2 || !change.isReplaceMode()) continue;
            this.copyStream(change.getInput(), archiveOutputStream, change.getEntry());
            iterator.remove();
            changeSetResults.addedFromChangeSet(change.getEntry().getName());
        }
        while (changeSetPerformer$ArchiveEntryIterator.hasNext()) {
            iterator = changeSetPerformer$ArchiveEntryIterator.next();
            boolean bl = true;
            Iterator iterator2 = linkedHashSet.iterator();
            while (iterator2.hasNext()) {
                Change change = (Change)iterator2.next();
                int n = change.type();
                String string = iterator.getName();
                if (n == 1 && string != null) {
                    if (!string.equals(change.targetFile())) continue;
                    bl = false;
                    iterator2.remove();
                    changeSetResults.deleted(string);
                    break;
                }
                if (n != 4 || string == null || !string.startsWith(change.targetFile() + "/")) continue;
                bl = false;
                changeSetResults.deleted(string);
                break;
            }
            if (!bl || this.isDeletedLater((Set<Change>)linkedHashSet, (ArchiveEntry)((Object)iterator)) || changeSetResults.hasBeenAdded(iterator.getName())) continue;
            this.copyStream(changeSetPerformer$ArchiveEntryIterator.getInputStream(), archiveOutputStream, (ArchiveEntry)((Object)iterator));
            changeSetResults.addedFromStream(iterator.getName());
        }
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Change change = (Change)iterator.next();
            if (change.type() != 2 || change.isReplaceMode() || changeSetResults.hasBeenAdded(change.getEntry().getName())) continue;
            this.copyStream(change.getInput(), archiveOutputStream, change.getEntry());
            iterator.remove();
            changeSetResults.addedFromChangeSet(change.getEntry().getName());
        }
        archiveOutputStream.finish();
        return changeSetResults;
    }

    private boolean isDeletedLater(Set<Change> set, ArchiveEntry archiveEntry) {
        String string = archiveEntry.getName();
        if (!set.isEmpty()) {
            for (Change change : set) {
                int n = change.type();
                String string2 = change.targetFile();
                if (n == 1 && string.equals(string2)) {
                    return true;
                }
                if (n != 4 || !string.startsWith(string2 + "/")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyStream(InputStream inputStream, ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry) {
        archiveOutputStream.putArchiveEntry(archiveEntry);
        IOUtils.copy(inputStream, archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }
}

