/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.brotli.dec.BrotliInputStream;

public class BrotliCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final BrotliInputStream decIS;

    public BrotliCompressorInputStream(InputStream inputStream) {
        this.countingStream = new CountingInputStream(inputStream);
        this.decIS = new BrotliInputStream((InputStream)this.countingStream);
    }

    @Override
    public int available() {
        return this.decIS.available();
    }

    @Override
    public void close() {
        this.decIS.close();
    }

    @Override
    public int read(byte[] byArray) {
        return this.decIS.read(byArray);
    }

    @Override
    public long skip(long l) {
        return IOUtils.skip((InputStream)this.decIS, l);
    }

    @Override
    public void mark(int n) {
        this.decIS.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.decIS.markSupported();
    }

    @Override
    public int read() {
        int n = this.decIS.read();
        this.count(n == -1 ? 0 : 1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.decIS.read(byArray, n, n2);
        this.count(n3);
        return n3;
    }

    public String toString() {
        return this.decIS.toString();
    }

    @Override
    public void reset() {
        this.decIS.reset();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

