/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate;

import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;

public class DeflateCompressorOutputStream
extends CompressorOutputStream {
    private final DeflaterOutputStream out;
    private final Deflater deflater;

    public DeflateCompressorOutputStream(OutputStream outputStream) {
        this(outputStream, new DeflateParameters());
    }

    public DeflateCompressorOutputStream(OutputStream outputStream, DeflateParameters deflateParameters) {
        this.deflater = new Deflater(deflateParameters.getCompressionLevel(), !deflateParameters.withZlibHeader());
        this.out = new DeflaterOutputStream(outputStream, this.deflater);
    }

    @Override
    public void write(int n) {
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    public void finish() {
        this.out.finish();
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        finally {
            this.deflater.end();
        }
    }
}

