/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder$1;

class HuffmanDecoder$DecodingMemory {
    private final byte[] memory;
    private final int mask;
    private int wHead;
    private boolean wrappedAround;

    private HuffmanDecoder$DecodingMemory() {
        this(16);
    }

    private HuffmanDecoder$DecodingMemory(int n) {
        this.memory = new byte[1 << n];
        this.mask = this.memory.length - 1;
    }

    byte add(byte by) {
        this.memory[this.wHead] = by;
        this.wHead = this.incCounter(this.wHead);
        return by;
    }

    void add(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.add(byArray[i]);
        }
    }

    void recordToBuffer(int n, int n2, byte[] byArray) {
        if (n > this.memory.length) {
            throw new IllegalStateException("Illegal distance parameter: " + n);
        }
        int n3 = this.wHead - n & this.mask;
        if (!this.wrappedAround && n3 >= this.wHead) {
            throw new IllegalStateException("Attempt to read beyond memory: dist=" + n);
        }
        int n4 = n3;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.add(this.memory[n4]);
            n4 = this.incCounter(n4);
        }
    }

    private int incCounter(int n) {
        int n2 = n + 1 & this.mask;
        if (!this.wrappedAround && n2 < n) {
            this.wrappedAround = true;
        }
        return n2;
    }

    /* synthetic */ HuffmanDecoder$DecodingMemory(HuffmanDecoder$1 huffmanDecoder$1) {
        this();
    }
}

